/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.io.DsonIOException;

public class DsonCodecException
extends DsonIOException {
    public DsonCodecException() {
    }

    public DsonCodecException(String message) {
        super(message);
    }

    public DsonCodecException(String message, Throwable cause) {
        super(message, cause);
    }

    public DsonCodecException(Throwable cause) {
        super(cause);
    }

    public DsonCodecException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public static DsonCodecException wrap(Exception e) {
        if (e instanceof DsonCodecException) {
            return (DsonCodecException)((Object)e);
        }
        return new DsonCodecException(e);
    }

    public static DsonCodecException unsupportedType(Class<?> type) {
        return new DsonCodecException("Can't find a codec for " + String.valueOf(type));
    }

    public static DsonCodecException unsupportedKeyType(Class<?> type) {
        return new DsonCodecException("Can't find a codec for " + String.valueOf(type) + ", or key is not EnumLite");
    }

    public static DsonCodecException enumAbsent(Class<?> declared, String value) {
        return new DsonCodecException(String.format("EnumLite is absent, declared: %s, value: %s", declared, value));
    }

    public static DsonCodecException incompatible(Class<?> declared, DsonType dsonType) {
        return new DsonCodecException(String.format("Incompatible data format, declaredType %s, dsonType %s", declared, dsonType));
    }

    public static DsonCodecException incompatible(DsonType expected, DsonType dsonType) {
        return new DsonCodecException(String.format("Incompatible data format, expected %s, dsonType %s", expected, dsonType));
    }

    public static DsonCodecException incompatible(Class<?> declared, String classId) {
        return new DsonCodecException(String.format("Incompatible data format, declaredType %s, classId %s", declared, classId));
    }
}

