/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.CachedGenericHelper;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.DefaultDsonConverter;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecCaster;
import cn.wjybxx.dsoncodec.DsonCodecConfig;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DynamicCodecRegistry;
import cn.wjybxx.dsoncodec.DynamicTypeMetaRegistry;
import cn.wjybxx.dsoncodec.GenericCodecInfo;
import cn.wjybxx.dsoncodec.GenericHelper;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeMetaConfig;
import cn.wjybxx.dsoncodec.TypeWriteHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class DsonConverterBuilder {
    public final TypeMetaConfig typeMetaConfig = new TypeMetaConfig();
    public final DsonCodecConfig codecConfig = new DsonCodecConfig();
    private ConverterOptions options = ConverterOptions.DEFAULT;

    public DsonConverterBuilder() {
        this(true);
    }

    public DsonConverterBuilder(boolean includeDefaults) {
        if (includeDefaults) {
            this.typeMetaConfig.mergeFrom(TypeMetaConfig.DEFAULT);
            this.codecConfig.mergeFrom(DsonCodecConfig.DEFAULT);
        }
    }

    public DsonConverter build() {
        return new DefaultDsonConverter(new DynamicTypeMetaRegistry(this.typeMetaConfig), new DynamicCodecRegistry(this.codecConfig), new CachedGenericHelper(this.codecConfig.getGenericHelpers()), new TypeWriteHelper(this.codecConfig.getOptimizedTypes()), this.options);
    }

    public DsonConverterBuilder addTypeMetaConfig(TypeMetaConfig typeMetaConfig) {
        this.typeMetaConfig.mergeFrom(typeMetaConfig);
        return this;
    }

    public DsonConverterBuilder addTypeMetaConfigs(Collection<TypeMetaConfig> typeMetaConfigs) {
        for (TypeMetaConfig typeMetaConfig : typeMetaConfigs) {
            this.typeMetaConfig.mergeFrom(typeMetaConfig);
        }
        return this;
    }

    public DsonConverterBuilder addTypeMetas(Collection<TypeMeta> typeMetas) {
        this.typeMetaConfig.addAll(typeMetas);
        return this;
    }

    public DsonConverterBuilder addTypeMetas(TypeMeta ... typeMetas) {
        this.typeMetaConfig.addAll(Arrays.asList(typeMetas));
        return this;
    }

    public DsonConverterBuilder addTypeMeta(TypeMeta typeMeta) {
        this.typeMetaConfig.add(typeMeta);
        return this;
    }

    public DsonConverterBuilder addTypeMeta(Class<?> type, String clsName) {
        this.typeMetaConfig.add(TypeMeta.of(type, ObjectStyle.INDENT, clsName));
        return this;
    }

    public DsonConverterBuilder addTypeMeta(Class<?> type, String ... clsName) {
        this.typeMetaConfig.add(TypeMeta.of(type, ObjectStyle.INDENT, clsName));
        return this;
    }

    public DsonConverterBuilder addTypeMeta(Class<?> type, ObjectStyle style, String clsName) {
        this.typeMetaConfig.add(TypeMeta.of(type, style, clsName));
        return this;
    }

    public DsonConverterBuilder addTypeMeta(Class<?> type, ObjectStyle style, String ... clsName) {
        this.typeMetaConfig.add(TypeMeta.of(type, style, clsName));
        return this;
    }

    public DsonConverterBuilder addCodecConfig(DsonCodecConfig codecConfig) {
        this.codecConfig.mergeFrom(codecConfig);
        return this;
    }

    public DsonConverterBuilder addCodecConfigs(Collection<DsonCodecConfig> codecConfigs) {
        for (DsonCodecConfig codecConfig : codecConfigs) {
            this.codecConfig.mergeFrom(codecConfig);
        }
        return this;
    }

    public <T> DsonConverterBuilder addCodec(Class<T> clazz, DsonCodec<? super T> codec) {
        this.codecConfig.addCodec(clazz, codec);
        return this;
    }

    public DsonConverterBuilder addCodec(DsonCodec<?> codec) {
        this.codecConfig.addCodec(codec);
        return this;
    }

    public DsonConverterBuilder addCodecs(DsonCodec<?> ... codecs) {
        this.codecConfig.addCodecs(Arrays.asList(codecs));
        return this;
    }

    public DsonConverterBuilder addCodecs(Collection<? extends DsonCodec<?>> codecs) {
        this.codecConfig.addCodecs(codecs);
        return this;
    }

    public DsonConverterBuilder addCodec(TypeInfo typeInfo, DsonCodec<?> codec) {
        this.codecConfig.addCodec(typeInfo, codec);
        return this;
    }

    public <T> DsonConverterBuilder addEncoder(Class<T> clazz, DsonCodec<? super T> codec) {
        this.codecConfig.addEncoder(clazz, codec);
        return this;
    }

    public DsonConverterBuilder addEncoder(TypeInfo typeInfo, DsonCodec<?> codec) {
        this.codecConfig.addEncoder(typeInfo, codec);
        return this;
    }

    public <T> DsonConverterBuilder addDecoder(Class<T> clazz, DsonCodec<? extends T> codec) {
        this.codecConfig.addDecoder(clazz, codec);
        return this;
    }

    public DsonConverterBuilder addDecoder(TypeInfo typeInfo, DsonCodec<?> codec) {
        this.codecConfig.addDecoder(typeInfo, codec);
        return this;
    }

    public DsonConverterBuilder addGenericCodec(TypeInfo genericType, Class<? extends DsonCodec> codecType) {
        this.codecConfig.addGenericCodec(genericType, codecType);
        return this;
    }

    public DsonConverterBuilder addGenericCodec(TypeInfo genericType, Class<? extends DsonCodec> codecType, Class<?> implType) {
        this.codecConfig.addGenericCodec(genericType, codecType, implType);
        return this;
    }

    public DsonConverterBuilder addGenericCodec(TypeInfo genericType, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        this.codecConfig.addGenericCodec(genericType, codecType, factory);
        return this;
    }

    public DsonConverterBuilder addGenericCodec(GenericCodecInfo genericCodecInfo) {
        this.codecConfig.addGenericCodec(genericCodecInfo);
        return this;
    }

    public DsonConverterBuilder addGenericEncoder(TypeInfo genericType, Class<? extends DsonCodec> codecType) {
        this.codecConfig.addGenericEncoder(genericType, codecType);
        return this;
    }

    public DsonConverterBuilder addGenericEncoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Class<?> implType) {
        this.codecConfig.addGenericEncoder(genericType, codecType, implType);
        return this;
    }

    public DsonConverterBuilder addGenericEncoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        this.codecConfig.addGenericEncoder(genericType, codecType, factory);
        return this;
    }

    public DsonConverterBuilder addGenericEncoder(GenericCodecInfo genericCodecInfo) {
        this.codecConfig.addGenericEncoder(genericCodecInfo);
        return this;
    }

    public DsonConverterBuilder addGenericDecoder(TypeInfo genericType, Class<? extends DsonCodec> codecType) {
        this.codecConfig.addGenericDecoder(genericType, codecType);
        return this;
    }

    public DsonConverterBuilder addGenericDecoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Class<?> implType) {
        this.codecConfig.addGenericDecoder(genericType, codecType, implType);
        return this;
    }

    public DsonConverterBuilder addGenericDecoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        this.codecConfig.addGenericDecoder(genericType, codecType, factory);
        return this;
    }

    public DsonConverterBuilder addGenericDecoder(GenericCodecInfo genericCodecInfo) {
        this.codecConfig.addGenericDecoder(genericCodecInfo);
        return this;
    }

    public DsonConverterBuilder addCaster(DsonCodecCaster caster) {
        this.codecConfig.addCaster(caster);
        return this;
    }

    public DsonConverterBuilder addCasters(Collection<? extends DsonCodecCaster> casters) {
        this.codecConfig.addCasters(casters);
        return this;
    }

    public <T> DsonConverterBuilder addOptimizedType(Class<T> encoderType, Class<? super T> declaredType) {
        this.codecConfig.addOptimizedType(encoderType, declaredType);
        return this;
    }

    public <T> DsonConverterBuilder addOptimizedType(Class<T> encoderType, Class<? super T> declaredType, boolean val) {
        this.codecConfig.addOptimizedType(encoderType, declaredType, val);
        return this;
    }

    public DsonConverterBuilder addGenericHelper(GenericHelper caster) {
        this.codecConfig.addGenericHelper(caster);
        return this;
    }

    public DsonConverterBuilder addGenericHelpers(Collection<? extends GenericHelper> casters) {
        this.codecConfig.addGenericHelpers(casters);
        return this;
    }

    public ConverterOptions getOptions() {
        return this.options;
    }

    public DsonConverterBuilder setOptions(ConverterOptions options) {
        this.options = options;
        return this;
    }
}

