/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.Duration;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class DurationCodec
implements DsonCodec<Duration> {
    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.of(Duration.class);
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Duration inst, TypeInfo declaredType, ObjectStyle style) {
        writer.writeTimestamp(null, Timestamp.ofDuration((Duration)inst));
    }

    @Override
    public Duration readObject(DsonObjectReader reader, Supplier<? extends Duration> factory) {
        Timestamp timestamp = reader.readTimestamp(null);
        return Duration.ofSeconds(timestamp.getSeconds(), timestamp.getNanos());
    }
}

