/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.EnumLite;
import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.text.StringStyle;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import cn.wjybxx.dsoncodec.annotations.DsonProperty;
import cn.wjybxx.dsoncodec.codecs.EnumValueInfo;
import cn.wjybxx.dsoncodec.codecs.IEnumCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@DsonCodecScanIgnore
public final class EnumCodec<T extends Enum<T>>
implements IEnumCodec<T> {
    private final Class<T> enumClass;
    private final EnumMap<T, EnumValueInfo<T>> value2EnumMap;
    private final Int2ObjectMap<EnumValueInfo<T>> number2EnumMap;
    private final Map<String, EnumValueInfo<T>> name2EnumMap;

    public EnumCodec(Class<T> enumClass, List<EnumValueInfo<T>> valueInfos) {
        this.enumClass = Objects.requireNonNull(enumClass);
        this.value2EnumMap = new EnumMap(enumClass);
        this.number2EnumMap = new Int2ObjectOpenHashMap(valueInfos.size());
        this.name2EnumMap = HashMap.newHashMap(valueInfos.size());
        for (EnumValueInfo<T> valueInfo : valueInfos) {
            this.value2EnumMap.put((Enum)valueInfo.value, valueInfo);
            this.number2EnumMap.put(valueInfo.number, valueInfo);
            this.name2EnumMap.put(valueInfo.name, valueInfo);
        }
    }

    public EnumCodec(Class<T> enumClass) {
        this.enumClass = Objects.requireNonNull(enumClass);
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        this.value2EnumMap = new EnumMap(enumClass);
        this.number2EnumMap = new Int2ObjectOpenHashMap(enumConstants.length);
        this.name2EnumMap = HashMap.newHashMap(enumConstants.length);
        Field[] enumFields = enumClass.getDeclaredFields();
        for (int idx = 0; idx < enumConstants.length; ++idx) {
            int n;
            Enum value = enumConstants[idx];
            if (value instanceof EnumLite) {
                EnumLite enumLite = (EnumLite)value;
                n = enumLite.getNumber();
            } else {
                n = value.ordinal();
            }
            int number = n;
            DsonProperty annotation = enumFields[idx].getAnnotation(DsonProperty.class);
            String name = annotation != null && !ObjectUtils.isBlank((String)annotation.name()) ? annotation.name() : value.name();
            EnumValueInfo<Enum> valueInfo = new EnumValueInfo<Enum>(value, number, name);
            this.value2EnumMap.put((Enum)valueInfo.value, valueInfo);
            this.number2EnumMap.put(valueInfo.number, valueInfo);
            this.name2EnumMap.put(valueInfo.name, valueInfo);
        }
    }

    @Override
    @Nullable
    public T forName(String name) {
        EnumValueInfo<T> valueInfo = this.name2EnumMap.get(name);
        return (T)(valueInfo == null ? null : (Enum)valueInfo.value);
    }

    @Override
    @Nullable
    public T forNumber(int number) {
        EnumValueInfo valueInfo = (EnumValueInfo)this.number2EnumMap.get(number);
        return (T)(valueInfo == null ? null : (Enum)valueInfo.value);
    }

    @Override
    public String getName(T val) {
        EnumValueInfo<T> valueInfo = this.value2EnumMap.get(val);
        return valueInfo.name;
    }

    @Override
    public int getNumber(T val) {
        EnumValueInfo<T> valueInfo = this.value2EnumMap.get(val);
        return valueInfo.number;
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.of(this.enumClass);
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, T inst, TypeInfo declaredType, ObjectStyle style) {
        EnumValueInfo<T> valueInfo = this.value2EnumMap.get(inst);
        if (valueInfo == null) {
            throw new DsonCodecException("invalid enum value: %s, type: %s".formatted(inst, this.enumClass));
        }
        if (writer.options().writeEnumAsString) {
            writer.writeString(null, valueInfo.name, StringStyle.UNQUOTE);
        } else {
            writer.writeInt(null, valueInfo.number);
        }
    }

    @Override
    public T readObject(DsonObjectReader reader, Supplier<? extends T> factory) {
        if (reader.options().writeEnumAsString) {
            String name = reader.readString(null);
            EnumValueInfo<T> valueInfo = this.name2EnumMap.get(name);
            if (valueInfo != null) {
                return (T)((Enum)valueInfo.value);
            }
            throw new DsonCodecException("invalid enum value: %s, type: %s".formatted(name, this.enumClass));
        }
        int number = reader.readInt(null);
        EnumValueInfo valueInfo = (EnumValueInfo)this.number2EnumMap.get(number);
        if (valueInfo != null) {
            return (T)((Enum)valueInfo.value);
        }
        throw new DsonCodecException("invalid enum value: %d, type: %s".formatted(number, this.enumClass));
    }
}

