/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class MapCodec<K, V>
implements DsonCodec<Map<K, V>> {
    protected final TypeInfo encoderType;
    protected final Supplier<? extends Map<K, V>> factory;
    private final FactoryKind factoryKind;

    public MapCodec(TypeInfo encoderType) {
        this(encoderType, null);
    }

    public MapCodec(TypeInfo encoderType, Supplier<? extends Map<K, V>> factory) {
        if (encoderType.typeArgs.size() != 2) {
            throw new IllegalArgumentException("encoderType.typeArgs.size() != 2");
        }
        if (factory == null) {
            factory = DsonConverterUtils.tryNoArgConstructorToSupplier(encoderType.rawType);
        }
        this.encoderType = encoderType;
        this.factory = factory;
        this.factoryKind = factory == null ? MapCodec.computeFactoryKind(encoderType) : FactoryKind.Unknown;
    }

    private static FactoryKind computeFactoryKind(TypeInfo typeInfo) {
        Class<?> clazz = typeInfo.rawType;
        if (clazz == EnumMap.class && typeInfo.typeArgs.get(0).isEnum()) {
            return FactoryKind.EnumMap;
        }
        if (ConcurrentMap.class.isAssignableFrom(clazz)) {
            return FactoryKind.ConcurrentMap;
        }
        return FactoryKind.Unknown;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.encoderType;
    }

    private Map<K, V> newMap() {
        if (this.factory != null) {
            return this.factory.get();
        }
        return switch (this.factoryKind.ordinal()) {
            case 1 -> {
                TypeInfo elementTypeInfo = this.encoderType.typeArgs.get(0);
                yield new EnumMap(elementTypeInfo.rawType);
            }
            case 2 -> new ConcurrentHashMap();
            default -> new LinkedHashMap();
        };
    }

    protected Map<K, V> toImmutable(Map<K, V> result) {
        if (result instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)result;
            return Collections.unmodifiableMap(linkedHashMap);
        }
        if (result instanceof EnumMap) {
            return Collections.unmodifiableMap(result);
        }
        return CollectionUtils.toImmutableLinkedHashMap(result);
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Map<K, V> inst, TypeInfo declaredType, ObjectStyle style) {
        TypeInfo keyTypeInfo = this.encoderType.typeArgs.get(0);
        TypeInfo valueTypeInfo = this.encoderType.typeArgs.get(1);
        Set<Map.Entry<K, V>> entrySet = inst.entrySet();
        if (writer.options().writeMapAsDocument) {
            writer.writeStartObject(style, this.encoderType, declaredType);
            for (Map.Entry<K, V> entry : entrySet) {
                String keyString = writer.encodeKey(entry.getKey(), keyTypeInfo);
                V value = entry.getValue();
                if (value == null) {
                    writer.writeName(keyString);
                    writer.writeNull(keyString);
                    continue;
                }
                writer.writeObject(keyString, value, valueTypeInfo, null);
            }
            writer.writeEndObject();
        } else {
            writer.writeStartArray(style, this.encoderType, declaredType);
            for (Map.Entry<K, V> entry : entrySet) {
                writer.writeObject(null, entry.getKey(), keyTypeInfo, null);
                writer.writeObject(null, entry.getValue(), valueTypeInfo, null);
            }
            writer.writeEndArray();
        }
    }

    @Override
    public Map<K, V> readObject(DsonObjectReader reader, Supplier<? extends Map<K, V>> factory) {
        Map result;
        TypeInfo keyTypeInfo = this.encoderType.typeArgs.get(0);
        TypeInfo valueTypeInfo = this.encoderType.typeArgs.get(1);
        Map<Object, Object> map = result = factory != null ? factory.get() : this.newMap();
        if (reader.options().writeMapAsDocument) {
            reader.readStartObject();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                String keyString = reader.readName();
                Object key = reader.decodeKey(keyString, keyTypeInfo);
                Object value = reader.readObject(keyString, valueTypeInfo);
                result.put(key, value);
            }
            reader.readEndObject();
        } else {
            reader.readStartArray();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                Object key = reader.readObject(null, keyTypeInfo);
                Object value = reader.readObject(null, valueTypeInfo);
                result.put(key, value);
            }
            reader.readEndArray();
        }
        return reader.options().readAsImmutable ? this.toImmutable(result) : result;
    }

    private static enum FactoryKind {
        Unknown,
        EnumMap,
        ConcurrentMap;

    }
}

