/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.fastutil;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatImmutableList;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class FloatCollectionCodec
implements DsonCodec<FloatCollection> {
    protected final TypeInfo typeInfo;
    protected final Supplier<? extends FloatCollection> factory;

    public FloatCollectionCodec(TypeInfo typeInfo) {
        this(typeInfo, null);
    }

    public FloatCollectionCodec(TypeInfo typeInfo, Supplier<? extends FloatCollection> factory) {
        Class<?> rawType = typeInfo.rawType;
        if (factory == null) {
            factory = DsonConverterUtils.tryNoArgConstructorToSupplier(rawType);
        }
        this.typeInfo = typeInfo;
        this.factory = factory;
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.typeInfo;
    }

    protected FloatCollection newCollection() {
        if (this.factory != null) {
            return this.factory.get();
        }
        return new FloatArrayList();
    }

    @Override
    public void writeObject(DsonObjectWriter writer, FloatCollection inst, TypeInfo declaredType, ObjectStyle style) {
        FloatIterator itr = inst.iterator();
        while (itr.hasNext()) {
            writer.writeFloat(null, itr.nextFloat());
        }
    }

    @Override
    public FloatCollection readObject(DsonObjectReader reader, Supplier<? extends FloatCollection> factory) {
        FloatCollection result;
        FloatCollection floatCollection = result = factory != null ? factory.get() : this.newCollection();
        while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
            result.add(reader.readFloat(null));
        }
        return reader.options().readAsImmutable ? new FloatImmutableList(result) : result;
    }
}

