/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.base.pool.ConcurrentObjectPool;
import cn.wjybxx.dson.DsonCollectionReader;
import cn.wjybxx.dson.DsonNull;
import cn.wjybxx.dson.DsonReader;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.DsonValue;
import cn.wjybxx.dsoncodec.AbstractObjectReader;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

final class BufferedDsonObjectReader
extends AbstractObjectReader
implements DsonObjectReader {
    private static final ConcurrentObjectPool<LinkedHashSet<String>> keySetPool = new ConcurrentObjectPool(() -> new LinkedHashSet(16), HashSet::clear, 256);

    public BufferedDsonObjectReader(DsonConverter converter, DsonCollectionReader reader) {
        super(converter, (DsonReader)reader);
    }

    @Override
    public boolean readName(String name) {
        DsonReader reader = this.reader;
        if (reader.getContextType().isArrayLike()) {
            if (reader.isAtValue()) {
                return true;
            }
            if (reader.isAtType()) {
                return reader.readDsonType() != DsonType.END_OF_OBJECT;
            }
            return reader.getCurrentDsonType() != DsonType.END_OF_OBJECT;
        }
        if (reader.isAtValue()) {
            if (name == null || reader.getCurrentName().equals(name)) {
                return true;
            }
            reader.skipValue();
        }
        Objects.requireNonNull(name, "name");
        if (reader.isAtType()) {
            KeyIterator keyItr = (KeyIterator)reader.attachment();
            if (keyItr.keySet.contains(name)) {
                keyItr.setNext(name);
                reader.readDsonType();
                reader.readName();
                return true;
            }
            return false;
        }
        if (reader.getCurrentDsonType() == DsonType.END_OF_OBJECT) {
            return false;
        }
        return name.equals(reader.readName());
    }

    @Override
    public void readStartObject() {
        super.readStartObject();
        DsonCollectionReader reader = (DsonCollectionReader)this.reader;
        KeyIterator keyItr = new KeyIterator(reader.getkeySet(), (LinkedHashSet)keySetPool.acquire());
        reader.setKeyItr((Iterator)keyItr, (DsonValue)DsonNull.NULL);
        reader.attach((Object)keyItr);
    }

    @Override
    public void readEndObject() {
        KeyIterator keyItr = (KeyIterator)this.reader.attach(null);
        super.readEndObject();
        keySetPool.release(keyItr.keyQueue);
        keyItr.keyQueue = null;
    }

    @Override
    public void setEncoderType(TypeInfo encoderType) {
        Object attachment = this.reader.attachment();
        if (attachment instanceof KeyIterator) {
            KeyIterator keyItr = (KeyIterator)attachment;
            keyItr.encoderType = encoderType;
        } else {
            this.reader.attach((Object)encoderType);
        }
    }

    @Override
    public TypeInfo getEncoderType() {
        Object attachment = this.reader.attachment();
        if (attachment instanceof KeyIterator) {
            KeyIterator keyItr = (KeyIterator)attachment;
            return keyItr.encoderType;
        }
        return (TypeInfo)attachment;
    }

    private static class KeyIterator
    implements Iterator<String> {
        Set<String> keySet;
        LinkedHashSet<String> keyQueue;
        TypeInfo encoderType;

        public KeyIterator(Set<String> keySet, LinkedHashSet<String> keyQueue) {
            this.keySet = keySet;
            this.keyQueue = keyQueue;
            keyQueue.addAll(keySet);
        }

        public void setNext(String nextName) {
            Objects.requireNonNull(nextName);
            if (this.keyQueue.size() > 0 && this.keyQueue.getFirst().equals(nextName)) {
                return;
            }
            this.keyQueue.addFirst(nextName);
        }

        @Override
        public boolean hasNext() {
            return !this.keyQueue.isEmpty();
        }

        @Override
        public String next() {
            return this.keyQueue.removeFirst();
        }
    }
}

