/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dsoncodec.ClassPair;
import cn.wjybxx.dsoncodec.GenericHelper;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CachedGenericHelper
implements GenericHelper {
    private final List<GenericHelper> userHelpers;
    private final ConcurrentHashMap<CacheKey, TypeInfo> resultCache = new ConcurrentHashMap(1024);
    private final ConcurrentHashMap<ClassPair, Boolean> inheritableCache = new ConcurrentHashMap(1024);

    public CachedGenericHelper() {
        this.userHelpers = List.of();
    }

    public CachedGenericHelper(List<GenericHelper> userHelpers) {
        this.userHelpers = List.copyOf(userHelpers);
    }

    @Override
    @Nullable
    public TypeInfo inheritTypeArgs(Class<?> runtimeType, TypeInfo declaredType) {
        if (runtimeType == declaredType.rawType) {
            return declaredType;
        }
        CacheKey cacheKey = new CacheKey(runtimeType, declaredType);
        TypeInfo typeInfo = this.resultCache.get(cacheKey);
        if (typeInfo != null) {
            return typeInfo == TypeInfo.OBJECT ? null : typeInfo;
        }
        if (runtimeType.isArray() || declaredType.isArrayType()) {
            typeInfo = this.inheritTypeArgs(runtimeType.isArray() ? ArrayUtils.getRootComponentType(runtimeType) : runtimeType, declaredType.isArrayType() ? declaredType.getRootComponentType() : declaredType);
            if (typeInfo != null && runtimeType.isArray()) {
                typeInfo = TypeInfo.of((Class)runtimeType, (List)typeInfo.typeArgs);
            }
        } else {
            GenericHelper userHelper;
            for (int i = this.userHelpers.size() - 1; i >= 0 && (typeInfo = (userHelper = this.userHelpers.get(i)).inheritTypeArgs(runtimeType, declaredType)) == null; --i) {
            }
            if (typeInfo == null && this.canInheritTypeArgs(runtimeType, declaredType.rawType)) {
                typeInfo = TypeInfo.of((Class)runtimeType, (List)declaredType.typeArgs);
            }
        }
        if (typeInfo == null) {
            typeInfo = TypeInfo.OBJECT;
        }
        this.resultCache.put(cacheKey, typeInfo);
        return typeInfo == TypeInfo.OBJECT ? null : typeInfo;
    }

    private boolean canInheritTypeArgs(Class<?> runtimeType, Class<?> declaredType) {
        ClassPair cacheKey = new ClassPair(runtimeType, declaredType);
        Boolean r = this.inheritableCache.get(cacheKey);
        if (r == null) {
            r = CachedGenericHelper.isSameGenericTypeArguments(runtimeType, declaredType);
            this.inheritableCache.put(cacheKey, r);
        }
        return r;
    }

    private static boolean isSameGenericTypeArguments(Class<?> runtimeType, Class<?> declaredType) {
        TypeVariable<Class<?>>[] declaredTypeParameters;
        TypeVariable<Class<?>>[] thisTypeParameters = runtimeType.getTypeParameters();
        if (thisTypeParameters.length != (declaredTypeParameters = declaredType.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < thisTypeParameters.length; ++i) {
            TypeVariable<Class<?>> thisTypeParameter = thisTypeParameters[i];
            TypeVariable<Class<?>> declaredTypeParameter = declaredTypeParameters[i];
            if (thisTypeParameter.getName().equals(declaredTypeParameter.getName())) continue;
            return false;
        }
        return true;
    }

    private static class CacheKey {
        public final Class<?> runtimeType;
        public final TypeInfo declaredType;

        public CacheKey(Class<?> runtimeType, TypeInfo declaredType) {
            this.runtimeType = runtimeType;
            this.declaredType = declaredType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.runtimeType == cacheKey.runtimeType && this.declaredType.equals(cacheKey.declaredType);
        }

        public int hashCode() {
            int result = this.runtimeType.hashCode();
            result = 31 * result + this.declaredType.hashCode();
            return result;
        }
    }
}

