/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.base.io.StringBuilderWriter;
import cn.wjybxx.dson.DsonArray;
import cn.wjybxx.dson.DsonBinaryReader;
import cn.wjybxx.dson.DsonBinaryWriter;
import cn.wjybxx.dson.DsonCollectionReader;
import cn.wjybxx.dson.DsonCollectionWriter;
import cn.wjybxx.dson.DsonReader;
import cn.wjybxx.dson.DsonReaderSettings;
import cn.wjybxx.dson.DsonValue;
import cn.wjybxx.dson.DsonWriter;
import cn.wjybxx.dson.Dsons;
import cn.wjybxx.dson.io.DsonChunk;
import cn.wjybxx.dson.io.DsonInput;
import cn.wjybxx.dson.io.DsonInputs;
import cn.wjybxx.dson.io.DsonOutput;
import cn.wjybxx.dson.io.DsonOutputs;
import cn.wjybxx.dson.text.DsonTextReader;
import cn.wjybxx.dson.text.DsonTextWriter;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.BufferedDsonObjectReader;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.DefaultDsonObjectReader;
import cn.wjybxx.dsoncodec.DefaultDsonObjectWriter;
import cn.wjybxx.dsoncodec.DsonCodecRegistry;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.GenericHelper;
import cn.wjybxx.dsoncodec.TypeMetaRegistry;
import cn.wjybxx.dsoncodec.TypeWriteHelper;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class DefaultDsonConverter
implements DsonConverter {
    private final TypeMetaRegistry typeMetaRegistry;
    private final DsonCodecRegistry codecRegistry;
    private final GenericHelper genericHelper;
    private final TypeWriteHelper typeWriteHelper;
    private final ConverterOptions options;

    DefaultDsonConverter(TypeMetaRegistry typeMetaRegistry, DsonCodecRegistry codecRegistry, GenericHelper genericHelper, TypeWriteHelper typeWriteHelper, ConverterOptions options) {
        this.codecRegistry = codecRegistry;
        this.typeMetaRegistry = typeMetaRegistry;
        this.genericHelper = genericHelper;
        this.typeWriteHelper = typeWriteHelper;
        this.options = options;
    }

    @Override
    public DsonCodecRegistry codecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public TypeMetaRegistry typeMetaRegistry() {
        return this.typeMetaRegistry;
    }

    @Override
    public GenericHelper genericCodecHelper() {
        return this.genericHelper;
    }

    @Override
    public ConverterOptions options() {
        return this.options;
    }

    @Override
    public DsonConverter withOptions(ConverterOptions options) {
        Objects.requireNonNull(options);
        return new DefaultDsonConverter(this.typeMetaRegistry, this.codecRegistry, this.genericHelper, this.typeWriteHelper, options);
    }

    @Override
    @Nonnull
    public byte[] write(Object value, @Nonnull TypeInfo declaredType) {
        Objects.requireNonNull(value);
        try (DsonOutputs.ArrayOutput outputStream = DsonOutputs.newInstance(this.options.bufferPool, (int)this.options.bufferLength, (int)this.options.maxBufferLength);){
            this.encodeObject((DsonOutput)outputStream, value, declaredType);
            byte[] byArray = Arrays.copyOfRange(outputStream.getBuffer(), 0, outputStream.getPosition());
            return byArray;
        }
    }

    @Override
    public <T> T read(byte[] source, @Nonnull TypeInfo declaredType, Supplier<? extends T> factory) {
        try (DsonInput inputStream = DsonInputs.newInstance((byte[])source);){
            T t = this.decodeObject(inputStream, declaredType, factory);
            return t;
        }
    }

    @Override
    public void write(Object value, TypeInfo declaredType, DsonChunk chunk) {
        Objects.requireNonNull(value);
        try (DsonOutput outputStream = DsonOutputs.newInstance((byte[])chunk.getBuffer(), (int)chunk.getOffset(), (int)chunk.getLength());){
            this.encodeObject(outputStream, value, declaredType);
            chunk.setUsed(outputStream.getPosition());
        }
    }

    @Override
    public <T> T read(DsonChunk chunk, TypeInfo declaredType, Supplier<? extends T> factory) {
        try (DsonInput inputStream = DsonInputs.newInstance((byte[])chunk.getBuffer(), (int)chunk.getOffset(), (int)chunk.getLength());){
            T result = this.decodeObject(inputStream, declaredType, factory);
            chunk.setUsed(inputStream.getPosition());
            T t = result;
            return t;
        }
    }

    @Override
    public <T> T cloneObject(Object value, TypeInfo declaredType, TypeInfo targetType, Supplier<? extends T> factory) {
        if (value == null) {
            return null;
        }
        try (DsonOutputs.ArrayOutput outputStream = DsonOutputs.newInstance(this.options.bufferPool, (int)this.options.bufferLength, (int)this.options.maxBufferLength);){
            this.encodeObject((DsonOutput)outputStream, value, declaredType);
            DsonInput inputStream = DsonInputs.newInstance((byte[])outputStream.getBuffer(), (int)0, (int)outputStream.getPosition());
            T t = this.decodeObject(inputStream, targetType, factory);
            return t;
        }
    }

    private void encodeObject(DsonOutput outputStream, Object value, TypeInfo typeInfo) {
        DsonBinaryWriter binaryWriter = new DsonBinaryWriter(this.options.binWriterSettings, outputStream, false);
        try (DefaultDsonObjectWriter wrapper = new DefaultDsonObjectWriter(this, this.typeWriteHelper, (DsonWriter)binaryWriter);){
            wrapper.writeObject(null, value, typeInfo, null);
            wrapper.flush();
        }
    }

    private <T> T decodeObject(DsonInput inputStream, TypeInfo typeInfo, Supplier<? extends T> factory) {
        DsonBinaryReader binaryReader = new DsonBinaryReader(this.options.binReaderSettings, inputStream, false);
        try (DsonObjectReader wrapper = this.wrapReader((DsonReader)binaryReader);){
            T t = wrapper.readObject(null, typeInfo, factory);
            return t;
        }
    }

    private DsonObjectReader wrapReader(DsonReader reader) {
        if (this.options.randomRead) {
            return new BufferedDsonObjectReader((DsonConverter)this, this.toDsonCollectionReader(reader));
        }
        return new DefaultDsonObjectReader(this, reader);
    }

    private DsonCollectionReader toDsonCollectionReader(DsonReader dsonReader) {
        assert (!(dsonReader instanceof DsonCollectionReader));
        DsonValue dsonValue = Dsons.readTopDsonValue((DsonReader)dsonReader);
        return DsonCollectionReader.unsafeCreate((DsonReaderSettings)this.options.binReaderSettings, (DsonValue)dsonValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String writeAsDson(Object value, @Nonnull TypeInfo declaredType, ObjectStyle style) {
        StringBuilder stringBuilder = (StringBuilder)this.options.stringBuilderPool.acquire();
        try {
            this.writeAsDson(value, declaredType, (Writer)new StringBuilderWriter(stringBuilder), style);
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.options.stringBuilderPool.release((Object)stringBuilder);
        }
    }

    @Override
    public <T> T readFromDson(CharSequence source, @Nonnull TypeInfo declaredType, Supplier<? extends T> factory) {
        try (DsonObjectReader wrapper = this.wrapReader((DsonReader)new DsonTextReader(this.options.textReaderSettings, source));){
            T t = wrapper.readObject(null, declaredType, factory);
            return t;
        }
    }

    @Override
    public void writeAsDson(Object value, @Nonnull TypeInfo declaredType, Writer writer, ObjectStyle style) {
        Objects.requireNonNull(writer, "writer");
        try (DefaultDsonObjectWriter wrapper = new DefaultDsonObjectWriter(this, this.typeWriteHelper, (DsonWriter)new DsonTextWriter(this.options.textWriterSettings, writer, false));){
            wrapper.writeObject(null, value, declaredType, style);
            wrapper.flush();
        }
    }

    @Override
    public <T> T readFromDson(Reader source, @Nonnull TypeInfo declaredType, Supplier<? extends T> factory) {
        try (DsonObjectReader wrapper = this.wrapReader((DsonReader)new DsonTextReader(this.options.textReaderSettings, Dsons.newStreamScanner((Reader)source, (boolean)false)));){
            T t = wrapper.readObject(null, declaredType, factory);
            return t;
        }
    }

    @Override
    public DsonValue writeAsDsonValue(Object value, TypeInfo declaredType) {
        Objects.requireNonNull(value);
        DsonArray outList = new DsonArray(1);
        try (DefaultDsonObjectWriter wrapper = new DefaultDsonObjectWriter(this, this.typeWriteHelper, (DsonWriter)new DsonCollectionWriter(this.options.binWriterSettings, outList));){
            wrapper.writeObject(null, value, declaredType, ObjectStyle.INDENT);
            DsonValue dsonValue = outList.get(0);
            if (dsonValue.getDsonType().isContainer()) {
                DsonValue dsonValue2 = dsonValue;
                return dsonValue2;
            }
            throw new IllegalArgumentException("value must be container");
        }
    }

    @Override
    public <T> T readFromDsonValue(DsonValue source, @Nonnull TypeInfo declaredType, Supplier<? extends T> factory) {
        if (!source.getDsonType().isContainer()) {
            throw new IllegalArgumentException("value must be container");
        }
        try (BufferedDsonObjectReader wrapper = new BufferedDsonObjectReader((DsonConverter)this, DsonCollectionReader.unsafeCreate((DsonReaderSettings)this.options.binReaderSettings, (DsonValue)source));){
            T t = wrapper.readObject(null, declaredType, factory);
            return t;
        }
    }

    @Override
    public DsonValue readAsDsonValue(Reader source) {
        try (DsonTextReader textReader = new DsonTextReader(this.options.textReaderSettings, Dsons.newStreamScanner((Reader)source, (boolean)false));){
            DsonValue dsonValue = Dsons.readTopDsonValue((DsonReader)textReader);
            return dsonValue;
        }
    }
}

