/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dsoncodec.ClassPair;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecCaster;
import cn.wjybxx.dsoncodec.GenericCodecInfo;
import cn.wjybxx.dsoncodec.GenericHelper;
import cn.wjybxx.dsoncodec.MapEncodeProxy;
import cn.wjybxx.dsoncodec.codecs.BinaryCodec;
import cn.wjybxx.dsoncodec.codecs.BooleanCodec;
import cn.wjybxx.dsoncodec.codecs.CollectionCodec;
import cn.wjybxx.dsoncodec.codecs.DoubleCodec;
import cn.wjybxx.dsoncodec.codecs.DurationCodec;
import cn.wjybxx.dsoncodec.codecs.ExtDateTimeCodec;
import cn.wjybxx.dsoncodec.codecs.FloatCodec;
import cn.wjybxx.dsoncodec.codecs.InstantCodec;
import cn.wjybxx.dsoncodec.codecs.Int32Codec;
import cn.wjybxx.dsoncodec.codecs.Int64Codec;
import cn.wjybxx.dsoncodec.codecs.LocalDateCodec;
import cn.wjybxx.dsoncodec.codecs.LocalDateTimeCodec;
import cn.wjybxx.dsoncodec.codecs.LocalTimeCodec;
import cn.wjybxx.dsoncodec.codecs.MapCodec;
import cn.wjybxx.dsoncodec.codecs.MapEncodeProxyCodec;
import cn.wjybxx.dsoncodec.codecs.MoreArrayCodecs;
import cn.wjybxx.dsoncodec.codecs.MorePrimitiveCodecs;
import cn.wjybxx.dsoncodec.codecs.ObjectLitePtrCodec;
import cn.wjybxx.dsoncodec.codecs.ObjectPtrCodec;
import cn.wjybxx.dsoncodec.codecs.StringCodec;
import cn.wjybxx.dsoncodec.codecs.TimestampCodec;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public final class DsonCodecConfig {
    private final Map<TypeInfo, DsonCodec<?>> encoderDic;
    private final Map<TypeInfo, DsonCodec<?>> decoderDic;
    private final Map<Class<?>, GenericCodecInfo> genericEncoderDic;
    private final Map<Class<?>, GenericCodecInfo> genericDecoderDic;
    private final List<DsonCodecCaster> casters;
    private final Map<ClassPair, Boolean> optimizedTypes;
    private final List<GenericHelper> genericHelpers;
    public static final DsonCodecConfig DEFAULT = DsonCodecConfig.newDefaultRegistry().toImmutable();

    public DsonCodecConfig() {
        this.encoderDic = new HashMap(32);
        this.decoderDic = new HashMap(32);
        this.genericEncoderDic = new IdentityHashMap(16);
        this.genericDecoderDic = new IdentityHashMap(16);
        this.casters = new ArrayList<DsonCodecCaster>(4);
        this.optimizedTypes = new HashMap<ClassPair, Boolean>(16);
        this.genericHelpers = new ArrayList<GenericHelper>(4);
    }

    private DsonCodecConfig(DsonCodecConfig other) {
        this.encoderDic = Map.copyOf(other.encoderDic);
        this.decoderDic = Map.copyOf(other.decoderDic);
        this.genericEncoderDic = Map.copyOf(other.genericEncoderDic);
        this.genericDecoderDic = Map.copyOf(other.genericDecoderDic);
        this.casters = List.copyOf(other.casters);
        this.optimizedTypes = Map.copyOf(other.optimizedTypes);
        this.genericHelpers = List.copyOf(other.genericHelpers);
    }

    public Map<TypeInfo, DsonCodec<?>> getEncoderDic() {
        return this.encoderDic;
    }

    public Map<TypeInfo, DsonCodec<?>> getDecoderDic() {
        return this.decoderDic;
    }

    public Map<Class<?>, GenericCodecInfo> getGenericEncoderDic() {
        return this.genericEncoderDic;
    }

    public Map<Class<?>, GenericCodecInfo> getGenericDecoderDic() {
        return this.genericDecoderDic;
    }

    public List<DsonCodecCaster> getCasters() {
        return this.casters;
    }

    public Map<ClassPair, Boolean> getOptimizedTypes() {
        return this.optimizedTypes;
    }

    public List<GenericHelper> getGenericHelpers() {
        return this.genericHelpers;
    }

    public static DsonCodecConfig fromCodecs(DsonCodec<?> ... codecs) {
        return DsonCodecConfig.fromCodecs(Arrays.asList(codecs));
    }

    public static DsonCodecConfig fromCodecs(Collection<? extends DsonCodec<?>> codecs) {
        DsonCodecConfig result = new DsonCodecConfig();
        for (DsonCodec<?> codec : codecs) {
            result.addCodec(codec);
        }
        return result.toImmutable();
    }

    public static DsonCodecConfig fromConfigs(Collection<? extends DsonCodecConfig> configs) {
        DsonCodecConfig result = new DsonCodecConfig();
        for (DsonCodecConfig dsonCodecConfig : configs) {
            result.mergeFrom(dsonCodecConfig);
        }
        return result.toImmutable();
    }

    public DsonCodecConfig toImmutable() {
        if (this.encoderDic instanceof HashMap) {
            return new DsonCodecConfig(this);
        }
        return this;
    }

    public void clear() {
        this.encoderDic.clear();
        this.decoderDic.clear();
        this.genericEncoderDic.clear();
        this.genericDecoderDic.clear();
        this.casters.clear();
        this.optimizedTypes.clear();
        this.genericHelpers.clear();
    }

    public DsonCodecConfig mergeFrom(DsonCodecConfig other) {
        if (this == other) {
            throw new IllegalArgumentException();
        }
        this.encoderDic.putAll(other.encoderDic);
        this.decoderDic.putAll(other.decoderDic);
        this.genericEncoderDic.putAll(other.genericEncoderDic);
        this.genericDecoderDic.putAll(other.genericDecoderDic);
        this.casters.addAll(other.casters);
        this.optimizedTypes.putAll(other.optimizedTypes);
        this.genericHelpers.addAll(other.genericHelpers);
        return this;
    }

    public DsonCodecConfig addCodecs(DsonCodec<?> ... codecs) {
        for (DsonCodec<?> codec : codecs) {
            this.addCodec(codec.getEncoderType(), codec);
        }
        return this;
    }

    public DsonCodecConfig addCodecs(Collection<? extends DsonCodec<?>> codecs) {
        for (DsonCodec<?> codec : codecs) {
            this.addCodec(codec.getEncoderType(), codec);
        }
        return this;
    }

    public DsonCodecConfig addCodec(DsonCodec<?> codec) {
        this.addCodec(codec.getEncoderType(), codec);
        return this;
    }

    public <T> DsonCodecConfig addCodec(Class<T> clazz, DsonCodec<? super T> codec) {
        return this.addCodec(TypeInfo.of(clazz), codec);
    }

    public DsonCodecConfig addCodec(TypeInfo typeInfo, DsonCodec<?> codec) {
        this.encoderDic.put(typeInfo, codec);
        this.decoderDic.put(typeInfo, codec);
        return this;
    }

    public <T> DsonCodecConfig addEncoder(Class<T> clazz, DsonCodec<? super T> codec) {
        this.addEncoder(TypeInfo.of(clazz), codec);
        return this;
    }

    public DsonCodecConfig addEncoder(TypeInfo typeInfo, DsonCodec<?> codec) {
        this.encoderDic.put(typeInfo, codec);
        return this;
    }

    public <T> DsonCodecConfig addDecoder(Class<T> clazz, DsonCodec<? extends T> codec) {
        this.addDecoder(TypeInfo.of(clazz), codec);
        return this;
    }

    public DsonCodecConfig addDecoder(TypeInfo typeInfo, DsonCodec<?> codec) {
        this.decoderDic.put(typeInfo, codec);
        return this;
    }

    public DsonCodec<?> removeEncoder(Class<?> clazz) {
        return this.encoderDic.remove(TypeInfo.of(clazz));
    }

    public DsonCodec<?> removeEncoder(TypeInfo typeInfo) {
        return this.encoderDic.remove(typeInfo);
    }

    public DsonCodec<?> removeDecoder(Class<?> clazz) {
        return this.decoderDic.remove(TypeInfo.of(clazz));
    }

    public DsonCodec<?> removeDecoder(TypeInfo typeInfo) {
        return this.decoderDic.remove(typeInfo);
    }

    public DsonCodecConfig addGenericCodec(TypeInfo genericType, Class<? extends DsonCodec> codecType) {
        this.addGenericCodec(GenericCodecInfo.create(genericType, codecType));
        return this;
    }

    public DsonCodecConfig addGenericCodec(TypeInfo genericType, Class<? extends DsonCodec> codecType, Class<?> implType) {
        this.addGenericCodec(GenericCodecInfo.create(genericType, codecType, implType));
        return this;
    }

    public DsonCodecConfig addGenericCodec(TypeInfo genericType, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        this.addGenericCodec(GenericCodecInfo.create(genericType, codecType, factory));
        return this;
    }

    public DsonCodecConfig addGenericCodec(GenericCodecInfo genericCodecInfo) {
        Objects.requireNonNull(genericCodecInfo);
        this.genericEncoderDic.put(genericCodecInfo.typeInfo.rawType, genericCodecInfo);
        this.genericDecoderDic.put(genericCodecInfo.typeInfo.rawType, genericCodecInfo);
        return this;
    }

    public DsonCodecConfig addGenericEncoder(TypeInfo genericType, Class<? extends DsonCodec> codecType) {
        this.addGenericEncoder(GenericCodecInfo.create(genericType, codecType));
        return this;
    }

    public DsonCodecConfig addGenericEncoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Class<?> implType) {
        this.addGenericEncoder(GenericCodecInfo.create(genericType, codecType, implType));
        return this;
    }

    public DsonCodecConfig addGenericEncoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        this.addGenericEncoder(GenericCodecInfo.create(genericType, codecType, factory));
        return this;
    }

    public DsonCodecConfig addGenericEncoder(GenericCodecInfo genericCodecInfo) {
        Objects.requireNonNull(genericCodecInfo);
        this.genericEncoderDic.put(genericCodecInfo.typeInfo.rawType, genericCodecInfo);
        return this;
    }

    public DsonCodecConfig addGenericDecoder(TypeInfo genericType, Class<? extends DsonCodec> codecType) {
        this.addGenericDecoder(GenericCodecInfo.create(genericType, codecType));
        return this;
    }

    public DsonCodecConfig addGenericDecoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Class<?> implType) {
        this.addGenericDecoder(GenericCodecInfo.create(genericType, codecType, implType));
        return this;
    }

    public DsonCodecConfig addGenericDecoder(TypeInfo genericType, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        this.addGenericDecoder(GenericCodecInfo.create(genericType, codecType, factory));
        return this;
    }

    public DsonCodecConfig addGenericDecoder(GenericCodecInfo genericCodecInfo) {
        this.genericDecoderDic.put(genericCodecInfo.typeInfo.rawType, genericCodecInfo);
        return this;
    }

    public DsonCodecConfig addCaster(DsonCodecCaster caster) {
        this.casters.add(caster);
        return this;
    }

    public DsonCodecConfig addCasters(Collection<? extends DsonCodecCaster> casters) {
        this.casters.addAll(casters);
        return this;
    }

    public <T> DsonCodecConfig addOptimizedType(Class<T> encoderType, Class<? super T> declaredType) {
        this.optimizedTypes.put(new ClassPair(encoderType, declaredType), true);
        return this;
    }

    public <T> DsonCodecConfig addOptimizedType(Class<T> encoderType, Class<? super T> declaredType, boolean val) {
        this.optimizedTypes.put(new ClassPair(encoderType, declaredType), val);
        return this;
    }

    public DsonCodecConfig addGenericHelper(GenericHelper genericHelper) {
        this.genericHelpers.add(genericHelper);
        return this;
    }

    public DsonCodecConfig addGenericHelpers(Collection<? extends GenericHelper> genericHelpers) {
        this.genericHelpers.addAll(genericHelpers);
        return this;
    }

    public DsonCodec<?> getEncoder(TypeInfo typeInfo) {
        return this.encoderDic.get(typeInfo);
    }

    public DsonCodec<?> getDecoder(TypeInfo typeInfo) {
        return this.decoderDic.get(typeInfo);
    }

    public GenericCodecInfo getGenericEncoderInfo(Class<?> genericTypeDefine) {
        return this.genericEncoderDic.get(genericTypeDefine);
    }

    public GenericCodecInfo getGenericDecoderInfo(Class<?> genericTypeDefine) {
        return this.genericDecoderDic.get(genericTypeDefine);
    }

    public static DsonCodecConfig newDefaultRegistry() {
        DsonCodecConfig config = new DsonCodecConfig();
        DsonCodecConfig.initDefaultCodecs(config);
        DsonCodecConfig.initDefaultGenericCodecs(config);
        DsonCodecConfig.initDefaultOptimizedTypes(config);
        return config;
    }

    private static void initDefaultOptimizedTypes(DsonCodecConfig config) {
        config.addOptimizedType(ArrayList.class, List.class);
        config.addOptimizedType(ArrayList.class, Collection.class);
        config.addOptimizedType(HashSet.class, Set.class);
        config.addOptimizedType(LinkedHashSet.class, Set.class);
        config.addOptimizedType(LinkedHashSet.class, HashSet.class);
        config.addOptimizedType(HashMap.class, Map.class);
        config.addOptimizedType(LinkedHashMap.class, Map.class);
        config.addOptimizedType(LinkedHashMap.class, HashMap.class);
    }

    private static void initDefaultGenericCodecs(DsonCodecConfig config) {
        config.addGenericCodec(TypeInfo.of(Collection.class, Object.class), CollectionCodec.class, ArrayList.class);
        config.addGenericCodec(TypeInfo.of(List.class, Object.class), CollectionCodec.class, ArrayList.class);
        config.addGenericCodec(TypeInfo.of(ArrayList.class, Object.class), CollectionCodec.class, ArrayList.class);
        config.addGenericCodec(TypeInfo.of(LinkedList.class, Object.class), CollectionCodec.class, LinkedList.class);
        config.addGenericCodec(TypeInfo.of(ArrayDeque.class, Object.class), CollectionCodec.class, ArrayDeque.class);
        config.addGenericCodec(TypeInfo.of(Set.class, Object.class), CollectionCodec.class, LinkedHashSet.class);
        config.addGenericCodec(TypeInfo.of(HashSet.class, Object.class), CollectionCodec.class, HashSet.class);
        config.addGenericCodec(TypeInfo.of(LinkedHashSet.class, Object.class), CollectionCodec.class, LinkedHashSet.class);
        config.addGenericCodec(TypeInfo.of(EnumSet.class, Enum.class), CollectionCodec.class);
        config.addGenericCodec(TypeInfo.of(Map.class, Object.class, Object.class), MapCodec.class, LinkedHashMap.class);
        config.addGenericCodec(TypeInfo.of(HashMap.class, Object.class, Object.class), MapCodec.class, HashMap.class);
        config.addGenericCodec(TypeInfo.of(LinkedHashMap.class, Object.class, Object.class), MapCodec.class, LinkedHashMap.class);
        config.addGenericCodec(TypeInfo.of(EnumMap.class, Enum.class, Object.class), MapCodec.class);
        config.addGenericCodec(TypeInfo.of(ConcurrentMap.class, Object.class, Object.class), MapCodec.class, ConcurrentHashMap.class);
        config.addGenericCodec(TypeInfo.of(ConcurrentHashMap.class, Object.class, Object.class), MapCodec.class, ConcurrentHashMap.class);
        config.addGenericCodec(TypeInfo.of(MapEncodeProxy.class, Object.class), MapEncodeProxyCodec.class);
    }

    private static void initDefaultCodecs(DsonCodecConfig config) {
        config.addCodec(new Int32Codec());
        config.addCodec(new Int64Codec());
        config.addCodec(new FloatCodec());
        config.addCodec(new DoubleCodec());
        config.addCodec(new BooleanCodec());
        config.addCodec(new StringCodec());
        config.addCodec(new BinaryCodec());
        config.addCodec(new ObjectPtrCodec());
        config.addCodec(new ObjectLitePtrCodec());
        config.addCodec(new ExtDateTimeCodec());
        config.addCodec(new TimestampCodec());
        config.addCodec(new MorePrimitiveCodecs.ShortCodec());
        config.addCodec(new MorePrimitiveCodecs.ByteCodec());
        config.addCodec(new MorePrimitiveCodecs.CharacterCodec());
        config.addCodec(Integer.TYPE, new Int32Codec());
        config.addCodec(Long.TYPE, new Int64Codec());
        config.addCodec(Float.TYPE, new FloatCodec());
        config.addCodec(Double.TYPE, new DoubleCodec());
        config.addCodec(Boolean.TYPE, new BooleanCodec());
        config.addCodec(Short.TYPE, new MorePrimitiveCodecs.ShortCodec());
        config.addCodec(Byte.TYPE, new MorePrimitiveCodecs.ByteCodec());
        config.addCodec(Character.TYPE, new MorePrimitiveCodecs.CharacterCodec());
        config.addCodec(new MoreArrayCodecs.ByteArrayCodec());
        config.addCodec(new MoreArrayCodecs.IntArrayCodec());
        config.addCodec(new MoreArrayCodecs.LongArrayCodec());
        config.addCodec(new MoreArrayCodecs.FloatArrayCodec());
        config.addCodec(new MoreArrayCodecs.DoubleArrayCodec());
        config.addCodec(new MoreArrayCodecs.BooleanArrayCodec());
        config.addCodec(new MoreArrayCodecs.StringArrayCodec());
        config.addCodec(new MoreArrayCodecs.ShortArrayCodec());
        config.addCodec(new MoreArrayCodecs.CharArrayCodec());
        config.addCodec(new LocalDateTimeCodec());
        config.addCodec(new LocalDateCodec());
        config.addCodec(new LocalTimeCodec());
        config.addCodec(new InstantCodec());
        config.addCodec(new DurationCodec());
    }
}

