/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.codecs.IEnumCodec;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class DsonCodecImpl<T> {
    private final DsonCodec<T> codec;
    private final TypeInfo encoderType;
    private final boolean autoStart;
    private final boolean writeAsArray;
    private final IEnumCodec<T> enumCodec;

    DsonCodecImpl(DsonCodec<T> codec) {
        IEnumCodec enumCodec;
        this.encoderType = Objects.requireNonNull(codec.getEncoderType());
        this.codec = codec;
        this.autoStart = codec.autoStartEnd();
        this.writeAsArray = this.autoStart && codec.isWriteAsArray();
        this.enumCodec = codec instanceof IEnumCodec ? (enumCodec = (IEnumCodec)codec) : null;
    }

    public DsonCodec<T> getCodec() {
        return this.codec;
    }

    @Nonnull
    public TypeInfo getEncoderType() {
        return this.encoderType;
    }

    public void writeObject(DsonObjectWriter writer, T inst, TypeInfo declaredType, ObjectStyle style) {
        if (this.autoStart) {
            if (this.writeAsArray) {
                writer.writeStartArray(style);
                writer.writeTypeInfo(this.encoderType, declaredType);
                this.codec.writeObject(writer, inst, declaredType, style);
                writer.writeEndArray();
            } else {
                writer.writeStartObject(style);
                writer.writeTypeInfo(this.encoderType, declaredType);
                this.codec.writeObject(writer, inst, declaredType, style);
                writer.writeEndObject();
            }
        } else {
            this.codec.writeObject(writer, inst, declaredType, style);
        }
    }

    public T readObject(DsonObjectReader reader, TypeInfo declaredType, Supplier<? extends T> factory) {
        if (this.autoStart) {
            T result;
            if (this.writeAsArray) {
                reader.readStartArray();
                reader.setEncoderType(this.encoderType);
                result = this.codec.readObject(reader, factory);
                reader.readEndArray();
            } else {
                reader.readStartObject();
                reader.setEncoderType(this.encoderType);
                result = this.codec.readObject(reader, factory);
                reader.readEndObject();
            }
            return result;
        }
        return this.codec.readObject(reader, factory);
    }

    public boolean isEnumCodec() {
        return this.enumCodec != null;
    }

    public T forNumber(int number) {
        if (this.enumCodec != null) {
            return this.enumCodec.forNumber(number);
        }
        throw new DsonCodecException("unexpected forNumber method call");
    }

    public T forName(String name) {
        if (this.enumCodec != null) {
            return this.enumCodec.forName(name);
        }
        throw new DsonCodecException("unexpected forName method call");
    }

    public int getNumber(T val) {
        if (this.enumCodec != null) {
            return this.enumCodec.getNumber(val);
        }
        throw new DsonCodecException("unexpected getNumber method call");
    }

    public String getName(T val) {
        if (this.enumCodec != null) {
            return this.enumCodec.getName(val);
        }
        throw new DsonCodecException("unexpected getName method call");
    }
}

