/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DsonConverterUtils {
    private static final MethodType SUPPLIER_INVOKE_TYPE = MethodType.methodType(Supplier.class);
    private static final MethodType SUPPLIER_GET_METHOD_TYPE = MethodType.methodType(Object.class);
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveTypeMap = new IdentityHashMap(9);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(9);
    private static final Map<Class<?>, Object> primitiveTypeDefaultValueMap = new IdentityHashMap(9);

    public static Object getDefaultValue(Class<?> type) {
        return type.isPrimitive() ? primitiveTypeDefaultValueMap.get(type) : null;
    }

    public static Class<?> boxIfPrimitiveType(Class<?> type) {
        return type.isPrimitive() ? primitiveTypeToWrapperMap.get(type) : type;
    }

    public static Class<?> unboxIfWrapperType(Class<?> type) {
        Class<?> result = wrapperToPrimitiveTypeMap.get(type);
        return result == null ? type : result;
    }

    public static boolean isBoxType(Class<?> type) {
        return wrapperToPrimitiveTypeMap.containsKey(type);
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return type.isPrimitive();
    }

    public static boolean isAssignableFrom(Class<?> lhsType, Class<?> rhsType) {
        Objects.requireNonNull(lhsType, "Left-hand side type must not be null");
        Objects.requireNonNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        if (lhsType.isPrimitive()) {
            Class<?> resolvedPrimitive = wrapperToPrimitiveTypeMap.get(rhsType);
            return lhsType == resolvedPrimitive;
        }
        Class<?> resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType);
        return resolvedWrapper != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isAssignableValue(Class<?> type, @Nullable Object value) {
        Objects.requireNonNull(type, "Type must not be null");
        return value == null ? !type.isPrimitive() : DsonConverterUtils.isAssignableFrom(type, value.getClass());
    }

    public static <T> T castValue(Class<T> type, Object value) {
        if (type.isPrimitive()) {
            Class<?> boxedType = primitiveTypeToWrapperMap.get(type);
            return (T)boxedType.cast(value);
        }
        return type.cast(value);
    }

    public static Class<?> getEncodeClass(Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.isEnum()) {
            return clazz;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass.isEnum()) {
            return superclass;
        }
        return clazz;
    }

    public static <T> boolean isEncodeAsArray(Class<T> encoderClass) {
        return encoderClass.isArray() || Collection.class.isAssignableFrom(encoderClass) || Map.class.isAssignableFrom(encoderClass);
    }

    public static <T> Supplier<T> noArgConstructorToSupplier(MethodHandles.Lookup lookup, Constructor<T> constructor) throws Throwable {
        Class<T> returnType = constructor.getDeclaringClass();
        CallSite callSite = LambdaMetafactory.metafactory(lookup, "get", SUPPLIER_INVOKE_TYPE, SUPPLIER_GET_METHOD_TYPE, lookup.unreflectConstructor(constructor), MethodType.methodType(returnType));
        Supplier supplier = callSite.getTarget().invoke();
        return supplier;
    }

    @Nullable
    public static <T> Supplier<T> tryNoArgConstructorToSupplier(Class<T> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                return null;
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return DsonConverterUtils.noArgConstructorToSupplier(lookup, constructor);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    static {
        wrapperToPrimitiveTypeMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveTypeMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveTypeMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveTypeMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveTypeMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveTypeMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveTypeMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveTypeMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveTypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : wrapperToPrimitiveTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry.getValue(), entry.getKey());
        }
        primitiveTypeDefaultValueMap.put(Boolean.class, Boolean.FALSE);
        primitiveTypeDefaultValueMap.put(Byte.class, (byte)0);
        primitiveTypeDefaultValueMap.put(Character.class, Character.valueOf('\u0000'));
        primitiveTypeDefaultValueMap.put(Double.class, 0.0);
        primitiveTypeDefaultValueMap.put(Float.class, Float.valueOf(0.0f));
        primitiveTypeDefaultValueMap.put(Integer.class, 0);
        primitiveTypeDefaultValueMap.put(Long.class, 0L);
        primitiveTypeDefaultValueMap.put(Short.class, (short)0);
        primitiveTypeDefaultValueMap.put(Void.class, null);
    }
}

