/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.base.TypeName;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeMetaConfig;
import cn.wjybxx.dsoncodec.TypeMetaRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class DynamicTypeMetaRegistry
implements TypeMetaRegistry {
    private final TypeMetaConfig basicRegistry;
    private final ConcurrentHashMap<String, TypeName> classNamePool = new ConcurrentHashMap(1024);
    private final ConcurrentHashMap<TypeInfo, TypeMeta> type2MetaDic = new ConcurrentHashMap(1024);
    private final ConcurrentHashMap<String, TypeMeta> name2MetaDic = new ConcurrentHashMap(1024);

    public DynamicTypeMetaRegistry(TypeMetaConfig config) {
        this.basicRegistry = config.toImmutable();
    }

    @Override
    @Nullable
    public TypeMeta ofType(TypeInfo type) {
        ObjectStyle style;
        TypeMeta typeMeta = this.basicRegistry.ofType(type);
        if (typeMeta != null) {
            return typeMeta;
        }
        typeMeta = this.type2MetaDic.get(type);
        if (typeMeta != null) {
            return typeMeta;
        }
        if (!type.isGenericType() && !type.isArrayType()) {
            return null;
        }
        if (type.isArrayType()) {
            style = ObjectStyle.INDENT;
        } else {
            TypeMeta rawTypeMeta = this.basicRegistry.ofType(TypeInfo.of((Class)type.rawType));
            if (rawTypeMeta == null) {
                throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
            }
            style = rawTypeMeta.style;
        }
        TypeName typeName = this.classNameOfType(type);
        String mainClsName = typeName.toString();
        typeMeta = TypeMeta.of(type, style, mainClsName);
        this.type2MetaDic.putIfAbsent(type, typeMeta);
        this.name2MetaDic.putIfAbsent(mainClsName, typeMeta);
        return typeMeta;
    }

    @Override
    public TypeMeta ofName(String clsName) {
        TypeMeta typeMeta = this.basicRegistry.ofName(clsName);
        if (typeMeta != null) {
            return typeMeta;
        }
        typeMeta = this.name2MetaDic.get(clsName);
        if (typeMeta != null) {
            return typeMeta;
        }
        TypeName typeName = this.parseName(clsName);
        TypeInfo type = this.typeOfClassName(typeName);
        typeMeta = this.ofType(type);
        if (typeMeta == null) {
            throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
        }
        if (typeMeta.clsNames.contains(clsName) || ObjectUtils.containsWhitespace((CharSequence)clsName)) {
            return typeMeta;
        }
        ArrayList<String> clsNames = new ArrayList<String>(typeMeta.clsNames.size() + 1);
        clsNames.addAll(typeMeta.clsNames);
        clsNames.add(clsName);
        typeMeta = TypeMeta.of(type, typeMeta.style, clsNames);
        this.type2MetaDic.put(type, typeMeta);
        for (String name : clsNames) {
            this.name2MetaDic.put(name, typeMeta);
        }
        return typeMeta;
    }

    private TypeName parseName(String clsName) {
        Objects.requireNonNull(clsName);
        TypeName typeName = this.classNamePool.get(clsName);
        if (typeName != null) {
            return typeName;
        }
        if (ObjectUtils.containsWhitespace((CharSequence)clsName)) {
            return TypeName.parse((String)clsName);
        }
        typeName = TypeName.parse((String)clsName);
        this.classNamePool.put(clsName, typeName);
        return typeName;
    }

    private TypeName classNameOfType(TypeInfo type) {
        if (type.isArrayType()) {
            TypeInfo rootElementType = TypeInfo.of((Class)ArrayUtils.getRootComponentType((Class)type.rawType), (List)type.typeArgs);
            int arrayRank = ArrayUtils.getArrayRank((Class)type.rawType);
            String clsName = String.valueOf(this.classNameOfType(rootElementType)) + ArrayUtils.arrayRankSymbol((int)arrayRank);
            return new TypeName(clsName);
        }
        if (type.isGenericType()) {
            TypeMeta typeMeta = this.basicRegistry.ofType(TypeInfo.of((Class)type.rawType));
            if (typeMeta == null) {
                throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
            }
            List genericTypeArgs = type.typeArgs;
            ArrayList<TypeName> typeArgTypeNames = new ArrayList<TypeName>(genericTypeArgs.size());
            for (TypeInfo genericTypeArg : genericTypeArgs) {
                typeArgTypeNames.add(this.classNameOfType(genericTypeArg));
            }
            return new TypeName(typeMeta.mainClsName(), typeArgTypeNames);
        }
        TypeMeta typeMeta = this.basicRegistry.ofType(type);
        if (typeMeta == null) {
            throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
        }
        return new TypeName(typeMeta.mainClsName());
    }

    private TypeInfo typeOfClassName(TypeName typeName) {
        TypeInfo result;
        int arrayRank = typeName.getArrayRank();
        if (arrayRank > 0) {
            result = this.typeOfClassName(new TypeName(typeName.getRootElement(), typeName.typeArgs));
        } else {
            TypeMeta typeMeta = this.basicRegistry.ofName(typeName.name);
            if (typeMeta == null) {
                throw new DsonCodecException("typeMeta absent, typeName: " + String.valueOf(typeName));
            }
            result = typeMeta.typeInfo;
            int typeArgsCount = typeName.typeArgs.size();
            if (typeArgsCount > 0) {
                TypeInfo[] typeArgs = new TypeInfo[typeArgsCount];
                for (int index = 0; index < typeArgsCount; ++index) {
                    typeArgs[index] = this.typeOfClassName((TypeName)typeName.typeArgs.get(index));
                }
                result = TypeInfo.of((Class)result.rawType, (TypeInfo[])typeArgs);
            }
        }
        if (arrayRank > 0) {
            result = result.makeArrayType(arrayRank);
        }
        return result;
    }
}

