/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonLites;
import javax.annotation.Nonnull;

public final class FieldNumber
implements Comparable<FieldNumber> {
    public static final FieldNumber ZERO = new FieldNumber(0, 0);
    private final int fullNumber;

    public FieldNumber(byte idep, int lnumber) {
        if (idep < 0 || idep > 7) {
            throw FieldNumber.invalidArgs(idep, lnumber);
        }
        if (lnumber < 0) {
            throw FieldNumber.invalidArgs(idep, lnumber);
        }
        this.fullNumber = DsonLites.makeFullNumber((int)idep, (int)lnumber);
    }

    private FieldNumber(int fullNumber) {
        this.fullNumber = fullNumber;
    }

    private static IllegalArgumentException invalidArgs(byte idep, int lnumber) {
        return new IllegalArgumentException(String.format("invalid idep:%d or lnumber:%d", lnumber, idep));
    }

    public static FieldNumber ofLnumber(int lnumber) {
        return new FieldNumber(0, lnumber);
    }

    public static FieldNumber ofFullNumber(int fullNumber) {
        return new FieldNumber(DsonLites.idepOfFullNumber((int)fullNumber), DsonLites.lnumberOfFullNumber((int)fullNumber));
    }

    public int getFullNumber() {
        return this.fullNumber;
    }

    public byte getIdep() {
        return DsonLites.idepOfFullNumber((int)this.fullNumber);
    }

    public int getLnumber() {
        return DsonLites.lnumberOfFullNumber((int)this.fullNumber);
    }

    public static int compare(int fullNumber1, int fullNumber2) {
        if (fullNumber1 == fullNumber2) {
            return 0;
        }
        int r = Byte.compare(DsonLites.idepOfFullNumber((int)fullNumber1), DsonLites.idepOfFullNumber((int)fullNumber2));
        if (r != 0) {
            return r;
        }
        return Integer.compare(DsonLites.lnumberOfFullNumber((int)fullNumber1), DsonLites.lnumberOfFullNumber((int)fullNumber2));
    }

    @Override
    public int compareTo(@Nonnull FieldNumber that) {
        return FieldNumber.compare(this.fullNumber, that.fullNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldNumber that = (FieldNumber)o;
        return this.fullNumber == that.fullNumber;
    }

    public int hashCode() {
        return this.fullNumber;
    }

    public String toString() {
        return "FieldNumber{idep=" + this.getIdep() + ", lnumber=" + this.getLnumber() + "}";
    }
}

