/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import java.lang.reflect.TypeVariable;
import java.util.function.Supplier;

public final class GenericCodecInfo {
    public final TypeInfo typeInfo;
    public final Class<? extends DsonCodec> codecType;
    public final Supplier<?> factory;

    private GenericCodecInfo(TypeInfo typeInfo, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        this.typeInfo = typeInfo;
        this.codecType = codecType;
        this.factory = factory;
    }

    public static GenericCodecInfo create(TypeInfo typeInfo, Class<? extends DsonCodec> codecType) {
        return GenericCodecInfo.createImpl(typeInfo, codecType, null);
    }

    public static GenericCodecInfo create(TypeInfo typeInfo, Class<? extends DsonCodec> codecType, Class<?> implType) {
        if (implType == null) {
            return GenericCodecInfo.createImpl(typeInfo, codecType, null);
        }
        if (!typeInfo.rawType.isAssignableFrom(implType)) {
            throw new IllegalArgumentException("bad implType");
        }
        Supplier<?> factory = DsonConverterUtils.tryNoArgConstructorToSupplier(implType);
        if (factory == null) {
            throw new IllegalArgumentException("bad implType");
        }
        return GenericCodecInfo.createImpl(typeInfo, codecType, factory);
    }

    public static GenericCodecInfo create(TypeInfo typeInfo, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        if (factory != null && !typeInfo.rawType.isInstance(factory.get())) {
            throw new IllegalArgumentException("bad factory");
        }
        return GenericCodecInfo.createImpl(typeInfo, codecType, factory);
    }

    private static GenericCodecInfo createImpl(TypeInfo typeInfo, Class<? extends DsonCodec> codecType, Supplier<?> factory) {
        TypeVariable<Class<T>>[] typeParameters = typeInfo.rawType.getTypeParameters();
        if (typeParameters.length == 0) {
            throw new IllegalArgumentException("rawType is not genericType, type:" + String.valueOf(typeInfo.rawType));
        }
        if (typeParameters.length != typeInfo.typeArgs.size()) {
            throw new IllegalArgumentException("rawType.GenericTypeArguments.Length != typeInfo.typeArgs.Length, type: " + String.valueOf(typeInfo.rawType));
        }
        if (typeParameters.length != codecType.getTypeParameters().length) {
            throw new IllegalArgumentException("rawType.GenericTypeArguments.Length != codecType.GenericTypeArguments.Length, type: " + String.valueOf(typeInfo.rawType));
        }
        return new GenericCodecInfo(typeInfo, codecType, factory);
    }
}

