/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.ObjectStyle;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TypeMeta {
    public final TypeInfo typeInfo;
    public final ObjectStyle style;
    public final List<String> clsNames;

    private TypeMeta(TypeInfo typeInfo, ObjectStyle style, List<String> clsNames) {
        if (clsNames.isEmpty()) {
            throw new IllegalArgumentException("clsNames is empty");
        }
        this.typeInfo = Objects.requireNonNull(typeInfo);
        this.style = Objects.requireNonNull(style);
        this.clsNames = List.copyOf(clsNames);
    }

    public String mainClsName() {
        return this.clsNames.get(0);
    }

    public TypeMeta withStyle(ObjectStyle style) {
        return new TypeMeta(this.typeInfo, style, this.clsNames);
    }

    public static TypeMeta of(Class<?> clazz, String clsName) {
        return new TypeMeta(TypeInfo.of(clazz), ObjectStyle.INDENT, List.of(clsName));
    }

    public static TypeMeta of(Class<?> clazz, String ... clsNames) {
        return new TypeMeta(TypeInfo.of(clazz), ObjectStyle.INDENT, List.of(clsNames));
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.of(clazz.getSimpleName()));
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style, String clsName) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.of(clsName));
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style, String ... clsNames) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.of(clsNames));
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style, List<String> clsNames) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.copyOf(clsNames));
    }

    public static TypeMeta of(TypeInfo typeInfo, ObjectStyle style, String clsName) {
        return new TypeMeta(typeInfo, style, List.of(clsName));
    }

    public static TypeMeta of(TypeInfo typeInfo, ObjectStyle style, String ... clsNames) {
        return new TypeMeta(typeInfo, style, List.of(clsNames));
    }

    public static TypeMeta of(TypeInfo typeInfo, ObjectStyle style, List<String> clsNames) {
        return new TypeMeta(typeInfo, style, List.copyOf(clsNames));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeMeta typeMeta = (TypeMeta)o;
        return this.typeInfo.equals(typeMeta.typeInfo) && this.style == typeMeta.style && CollectionUtils.sequenceEqual(this.clsNames, typeMeta.clsNames);
    }

    public int hashCode() {
        int result = this.typeInfo.hashCode();
        result = 31 * result + this.style.hashCode();
        result = 31 * result + this.clsNames.hashCode();
        return result;
    }

    public String toString() {
        return "TypeMeta{type=" + String.valueOf(this.typeInfo) + ", style=" + String.valueOf(this.style) + ", classNames=" + String.valueOf(this.clsNames) + "}";
    }
}

