/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.MapEncodeProxy;
import cn.wjybxx.dsoncodec.TypeMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeMetaConfig {
    private final Map<TypeInfo, TypeMeta> type2MetaMap;
    private final Map<String, TypeMeta> name2MetaMap;
    public static final TypeMetaConfig DEFAULT = TypeMetaConfig.newDefaultConfig().toImmutable();

    public TypeMetaConfig() {
        this.type2MetaMap = new HashMap<TypeInfo, TypeMeta>(32);
        this.name2MetaMap = new HashMap<String, TypeMeta>(32);
    }

    private TypeMetaConfig(TypeMetaConfig other) {
        this.type2MetaMap = Map.copyOf(other.type2MetaMap);
        this.name2MetaMap = Map.copyOf(other.name2MetaMap);
    }

    public Map<TypeInfo, TypeMeta> getType2MetaMap() {
        return this.type2MetaMap;
    }

    public Map<String, TypeMeta> getName2MetaMap() {
        return this.name2MetaMap;
    }

    public static TypeMetaConfig fromTypeMetas(TypeMeta ... typeMetas) {
        return new TypeMetaConfig().addAll(Arrays.asList(typeMetas)).toImmutable();
    }

    public static TypeMetaConfig fromTypeMetas(Collection<TypeMeta> typeMetas) {
        return new TypeMetaConfig().addAll(typeMetas).toImmutable();
    }

    public static TypeMetaConfig fromConfigs(Collection<? extends TypeMetaConfig> configs) {
        TypeMetaConfig result = new TypeMetaConfig();
        for (TypeMetaConfig typeMetaConfig : configs) {
            result.mergeFrom(typeMetaConfig);
        }
        return result.toImmutable();
    }

    public TypeMetaConfig toImmutable() {
        if (this.type2MetaMap instanceof HashMap) {
            return new TypeMetaConfig(this);
        }
        return this;
    }

    public void clear() {
        this.type2MetaMap.clear();
        this.name2MetaMap.clear();
    }

    public TypeMetaConfig mergeFrom(TypeMetaConfig other) {
        if (this == other) {
            throw new IllegalArgumentException();
        }
        for (TypeMeta typeMeta : other.type2MetaMap.values()) {
            this.add(typeMeta);
        }
        return this;
    }

    public TypeMetaConfig addAll(Collection<TypeMeta> typeMetas) {
        for (TypeMeta typeMeta : typeMetas) {
            this.add(typeMeta);
        }
        return this;
    }

    public TypeMetaConfig add(TypeMeta typeMeta) {
        TypeInfo typeInfo = typeMeta.typeInfo;
        TypeMeta exist = this.type2MetaMap.get(typeInfo);
        if (exist != null) {
            if (exist.equals(typeMeta)) {
                return this;
            }
            throw new IllegalArgumentException("type conflict, type: %s".formatted(typeInfo));
        }
        this.type2MetaMap.put(typeInfo, typeMeta);
        for (String clsName : typeMeta.clsNames) {
            if (this.name2MetaMap.containsKey(clsName)) {
                throw new IllegalArgumentException("clsName conflict, type: %s, clsName: %s".formatted(typeInfo, clsName));
            }
            this.name2MetaMap.put(clsName, typeMeta);
        }
        return this;
    }

    public TypeMeta remove(TypeInfo typeInfo) {
        TypeMeta typeMeta = this.type2MetaMap.remove(typeInfo);
        if (typeMeta != null) {
            for (String clsName : typeMeta.clsNames) {
                this.name2MetaMap.remove(clsName);
            }
        }
        return typeMeta;
    }

    public TypeMetaConfig add(Class<?> type, String clsName) {
        this.add(TypeMeta.of(type, ObjectStyle.INDENT, clsName));
        return this;
    }

    public TypeMetaConfig add(Class<?> type, String ... clsName) {
        this.add(TypeMeta.of(type, ObjectStyle.INDENT, clsName));
        return this;
    }

    public TypeMetaConfig add(Class<?> type, ObjectStyle style, String clsName) {
        this.add(TypeMeta.of(type, style, clsName));
        return this;
    }

    public TypeMetaConfig add(Class<?> type, ObjectStyle style, String ... clsName) {
        this.add(TypeMeta.of(type, style, clsName));
        return this;
    }

    public TypeMeta ofType(TypeInfo type) {
        return this.type2MetaMap.get(type);
    }

    public TypeMeta ofName(String clsName) {
        return this.name2MetaMap.get(clsName);
    }

    public static TypeMetaConfig newDefaultConfig() {
        return TypeMetaConfig.newDefaultConfig(true);
    }

    public static TypeMetaConfig newDefaultConfig(boolean includeCollections) {
        TypeMetaConfig config = new TypeMetaConfig();
        config.add(Integer.TYPE, "i", "int", "int32", "ui", "uint", "uint32");
        config.add(Long.TYPE, "L", "long", "int64", "uL", "ulong", "uint64");
        config.add(Float.TYPE, "f", "float");
        config.add(Double.TYPE, "d", "double");
        config.add(Boolean.TYPE, "b", "bool", "boolean");
        config.add(String.class, "s", "string");
        config.add(Binary.class, "bin", "bytes");
        config.add((Class<?>)ObjectPtr.class, "ptr");
        config.add((Class<?>)ObjectLitePtr.class, "lptr");
        config.add((Class<?>)ExtDateTime.class, "dt");
        config.add((Class<?>)Timestamp.class, "ts");
        config.add(Short.TYPE, "short", "int16", "uint16");
        config.add(Byte.TYPE, "byte", "sbyte");
        config.add((Class<?>)Character.TYPE, "char");
        config.add((Class<?>)Integer.class, "Int");
        config.add((Class<?>)Long.class, "Long");
        config.add((Class<?>)Float.class, "Float");
        config.add((Class<?>)Double.class, "Double");
        config.add((Class<?>)Boolean.class, "Bool");
        config.add((Class<?>)Short.class, "Short");
        config.add((Class<?>)Byte.class, "Byte");
        config.add((Class<?>)Character.class, "Char");
        config.add((Class<?>)Number.class, "Number");
        config.add(Object.class, "object", "Object");
        if (includeCollections) {
            config.add(Collection.class, "ICollection", "ICollection`1");
            config.add(List.class, "IList", "IList`1");
            config.add(ArrayList.class, "List", "List`1");
            config.add(Map.class, "IDictionary", "IDictionary`2");
            config.add(HashMap.class, "HashMap", "HashMap`2");
            config.add(LinkedHashMap.class, "Dictionary", "Dictionary`2", "LinkedDictionary", "LinkedDictionary`2");
            config.add(ConcurrentHashMap.class, "ConcurrentDictionary", "ConcurrentDictionary`2");
            config.add(MapEncodeProxy.class, "DictionaryEncodeProxy", "MapEncodeProxy");
        }
        return config;
    }
}

