/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class FloatCodec
implements DsonCodec<Float> {
    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.BOXED_FLOAT;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Float inst, TypeInfo declaredType, ObjectStyle style) {
        NumberStyle numberStyle = declaredType.rawType == Float.class || declaredType.rawType == Float.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
        writer.writeFloat(null, inst.floatValue(), (INumberStyle)numberStyle);
    }

    @Override
    public Float readObject(DsonObjectReader reader, Supplier<? extends Float> factory) {
        return Float.valueOf(reader.readFloat(null));
    }
}

