/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.Instant;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class InstantCodec
implements DsonCodec<Instant> {
    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.of(Instant.class);
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Instant inst, TypeInfo declaredType, ObjectStyle style) {
        writer.writeTimestamp(null, Timestamp.ofInstant((Instant)inst));
    }

    @Override
    public Instant readObject(DsonObjectReader reader, Supplier<? extends Instant> factory) {
        Timestamp timestamp = reader.readTimestamp(null);
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }
}

