/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class Int64Codec
implements DsonCodec<Long> {
    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.BOXED_LONG;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Long inst, TypeInfo declaredType, ObjectStyle style) {
        NumberStyle numberStyle = declaredType.rawType == Long.class || declaredType.rawType == Long.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
        writer.writeLong(null, inst, (INumberStyle)numberStyle);
    }

    @Override
    public Long readObject(DsonObjectReader reader, Supplier<? extends Long> factory) {
        return reader.readLong(null);
    }
}

