/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class LocalDateTimeCodec
implements DsonCodec<LocalDateTime> {
    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.of(LocalDateTime.class);
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, LocalDateTime inst, TypeInfo declaredType, ObjectStyle style) {
        ExtDateTime dateTime = ExtDateTime.ofDateTime((LocalDateTime)inst);
        writer.writeExtDateTime(null, dateTime);
    }

    @Override
    public LocalDateTime readObject(DsonObjectReader reader, Supplier<? extends LocalDateTime> factory) {
        ExtDateTime dateTime = reader.readExtDateTime(null);
        return LocalDateTime.ofEpochSecond(dateTime.getSeconds(), dateTime.getNanos(), ZoneOffset.UTC);
    }
}

