/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.LocalTime;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class LocalTimeCodec
implements DsonCodec<LocalTime> {
    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.of(LocalTime.class);
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, LocalTime inst, TypeInfo declaredType, ObjectStyle style) {
        writer.writeExtDateTime(null, LocalTimeCodec.toDateTime(inst));
    }

    @Override
    public LocalTime readObject(DsonObjectReader reader, Supplier<? extends LocalTime> factory) {
        ExtDateTime dateTime = reader.readExtDateTime(null);
        return LocalTimeCodec.ofDateTime(dateTime);
    }

    private static LocalTime ofDateTime(ExtDateTime dateTime) {
        long nanoOfDay = dateTime.getSeconds() * 1000000000L + (long)dateTime.getNanos();
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    private static ExtDateTime toDateTime(LocalTime localTime) {
        return new ExtDateTime((long)localTime.toSecondOfDay(), localTime.getNano(), 0, 2);
    }
}

