/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.fastutil;

import cn.wjybxx.base.TypeInfo;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DoubleCollectionCodec
implements DsonCodec<DoubleCollection> {
    protected final TypeInfo typeInfo;
    protected final Supplier<? extends DoubleCollection> factory;

    public DoubleCollectionCodec(TypeInfo typeInfo) {
        this(typeInfo, null);
    }

    public DoubleCollectionCodec(TypeInfo typeInfo, Supplier<? extends DoubleCollection> factory) {
        if (factory == null) {
            Class rawType = typeInfo.rawType;
            factory = DsonConverterUtils.tryNoArgConstructorToSupplier(rawType);
        }
        this.typeInfo = typeInfo;
        this.factory = factory;
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.typeInfo;
    }

    protected DoubleCollection newCollection() {
        if (this.factory != null) {
            return this.factory.get();
        }
        return new DoubleArrayList();
    }

    @Override
    public void writeObject(DsonObjectWriter writer, DoubleCollection inst, TypeInfo declaredType, ObjectStyle style) {
        DoubleIterator itr = inst.iterator();
        while (itr.hasNext()) {
            writer.writeDouble(null, itr.nextDouble());
        }
    }

    @Override
    public DoubleCollection readObject(DsonObjectReader reader, Supplier<? extends DoubleCollection> factory) {
        DoubleCollection result;
        DoubleCollection doubleCollection = result = factory != null ? factory.get() : this.newCollection();
        while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
            result.add(reader.readDouble(null));
        }
        return reader.options().readAsImmutable ? new DoubleImmutableList(result) : result;
    }
}

