/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodWrapper {
    private static final Logger log = LoggerFactory.getLogger(MethodWrapper.class);
    private final Method targetMethod;
    private final Object targetObject;
    private final HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig;
    private final String targetMethodKey;

    public MethodWrapper(Object targetObject, Method targetMethod) {
        this(targetObject, targetMethod, null);
    }

    public MethodWrapper(Object targetObject, Method targetMethod, HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig) {
        this.targetObject = targetObject;
        this.targetMethod = targetMethod;
        this.targetMethodKey = MethodWrapper.generateMethodKey(targetMethod);
        this.homeKitAccessoryTypeConfig = homeKitAccessoryTypeConfig;
    }

    public Object invoke(Map<Method, HomekitCharacteristicChangeCallback> subscribeMap, Object[] args) {
        Object targetReturnObject;
        if (this.homeKitAccessoryTypeConfig == null) {
            return this.targetMethod.invoke(this.targetObject, args);
        }
        switch (this.homeKitAccessoryTypeConfig.getInvokeType()) {
            case VALUE: {
                targetReturnObject = this.generateValueReturnObject();
                break;
            }
            case INVOKE_METHOD: {
                targetReturnObject = this.targetMethod.invoke(this.targetObject, args);
                break;
            }
            case HTTP: {
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u8c03\u7528\u7c7b\u578b");
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u8c03\u7528\u7c7b\u578b");
            }
        }
        Map<String, HomekitCharacteristicChangeCallback> methodKeyMap = subscribeMap.entrySet().stream().collect(Collectors.toMap(k -> MethodWrapper.generateMethodKey((Method)k.getKey()), Map.Entry::getValue));
        String targetMethodName = this.targetMethod.getName();
        if (methodKeyMap.containsKey(this.targetMethodKey) && targetMethodName.startsWith("set")) {
            HomekitCharacteristicChangeCallback homekitCharacteristicChangeCallback = methodKeyMap.get(this.targetMethodKey);
            homekitCharacteristicChangeCallback.changed();
            log.debug("\u8c03\u7528\u65b9\u6cd5:{}\u89e6\u53d1\u8ba2\u9605{}\u66f4\u65b0", (Object)this.targetMethod.getDeclaringClass().getName().concat("#").concat(targetMethodName).concat("()"), (Object)this.targetMethodKey);
        } else if (!targetMethodName.startsWith("get")) {
            log.warn("\u8fd8\u6ca1\u6709\u8be5\u8ba2\u9605:".concat(this.targetMethodKey).concat(",\u8c03\u7528\u65b9\u6cd5:").concat(this.targetMethod.getDeclaringClass().getName()).concat("#").concat(targetMethodName).concat("()"));
            log.debug("\u5b58\u5728\u7684\u8ba2\u9605:{}", methodKeyMap);
        }
        return targetReturnObject;
    }

    private Object generateValueReturnObject() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> returnType = this.targetMethod.getReturnType();
        if (CompletableFuture.class.equals(returnType)) {
            Type[] actualTypeArguments;
            Type[] typeArray;
            int n;
            int n2;
            Type genericSuperclass = this.targetMethod.getGenericReturnType();
            if (genericSuperclass instanceof ParameterizedType && (n2 = 0) < (n = (typeArray = (actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments())).length)) {
                Object targetReturnObject;
                Type actualTypeArgument = typeArray[n2];
                Class targetReturnClass = (Class)actualTypeArgument;
                if (!Void.class.equals((Object)targetReturnClass)) {
                    String arg = Optional.ofNullable(this.homeKitAccessoryTypeConfig.getReturnArg()).orElseThrow(() -> new IllegalArgumentException("\u8fd4\u56de\u503c\u4e0d\u80fd\u4e3a\u7a7a")).getArg();
                    if (targetReturnClass.isEnum()) {
                        Method valueOf = targetReturnClass.getMethod("valueOf", String.class);
                        targetReturnObject = valueOf.invoke((Object)targetReturnClass, arg);
                    } else {
                        targetReturnObject = targetReturnClass.getConstructor(String.class).newInstance(arg);
                    }
                } else {
                    targetReturnObject = null;
                }
                return CompletableFuture.completedFuture(targetReturnObject);
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8fd9\u4e2a\u8fd4\u56de\u7c7b\u578b:".concat(returnType.getTypeName()).concat(genericSuperclass.getTypeName()));
        }
        if (Void.class.equals(returnType)) {
            return null;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8fd9\u4e2a\u8fd4\u56de\u7c7b\u578b:".concat(returnType.getTypeName()));
    }

    private static String generateMethodKey(Method targetMethod) {
        String methodName = targetMethod.getName();
        if (methodName.startsWith("get")) {
            return methodName.substring(3);
        }
        if (methodName.startsWith("set")) {
            return methodName.substring(3);
        }
        if (methodName.startsWith("subscribe")) {
            return methodName.substring(9);
        }
        if (methodName.startsWith("unsubscribe")) {
            return methodName.substring(11);
        }
        return methodName;
    }
}

