package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import io.github.hapjava.accessories.HomekitAccessory;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * HomeKitProxyFactory
 *
 * @author W9004844
 * @since 2020/01/19 14:26
 */
public class HomeKitAccessoryProxyFactory {

    /**
     * HomeKitAccessory数据库对象
     */
    private final HomeKitAccessoryConfig homeKitAccessoryConfig;

    /**
     * 不止有一个接口
     */
    private final Class<?>[] homeKitAccessoryInterfaces;

    /**
     * 方法缓存Map
     */
    private final Map<Method, HomeKitAccessoryMethod> methodCacheMap = new ConcurrentHashMap<>();

    public HomeKitAccessoryProxyFactory(HomeKitAccessoryConfig homeKitAccessoryConfig) {
        this.homeKitAccessoryConfig = homeKitAccessoryConfig;
        this.homeKitAccessoryInterfaces = homeKitAccessoryConfig.getAccessoryTypeMap().keySet().toArray(new Class[0]);
    }

    public Class<?>[] getHomeKitAccessoryInterfaces() {
        return homeKitAccessoryInterfaces;
    }

    public Map<Method, HomeKitAccessoryMethod> getMethodCacheMap() {
        return methodCacheMap;
    }

    protected HomekitAccessory newInstance(HomeKitAccessoryProxy homeKitAccessoryProxy) {
        return (HomekitAccessory) Proxy.newProxyInstance(HomekitAccessory.class.getClassLoader(), homeKitAccessoryInterfaces, homeKitAccessoryProxy);
    }

    public HomekitAccessory newInstance() {
        return newInstance(new HomeKitAccessoryProxy(homeKitAccessoryConfig, methodCacheMap));
    }

}
