/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import cn.ximcloud.homekit.core.proxy.MethodWrapper;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.ReflectionUtils;

public class HomeKitAccessoryMethod {
    private static final Set<Method> homeKitAccessoryMethodCacheSet = ReflectionUtils.getMethods(HomekitAccessory.class, (Predicate[])new Predicate[0]);
    private final MethodWrapper method;

    public HomeKitAccessoryMethod(HomeKitAccessoryConfig homeKitAccessoryConfig, Method method) {
        this.method = this.initTargetMethod(homeKitAccessoryConfig, method);
    }

    private MethodWrapper initTargetMethod(HomeKitAccessoryConfig homeKitAccessoryConfig, Method method) {
        if (homeKitAccessoryMethodCacheSet.contains(method)) {
            return new MethodWrapper(homeKitAccessoryConfig, HomeKitAccessoryConfig.class.getDeclaredMethod(method.getName(), new Class[0]));
        }
        return new MethodWrapper(homeKitAccessoryConfig, method, this.findHomeKitAccessoryTypeConfig(homeKitAccessoryConfig, method));
    }

    private HomeKitAccessoryTypeConfig findHomeKitAccessoryTypeConfig(HomeKitAccessoryConfig homeKitAccessoryConfig, Method method) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> declaringClass = method.getDeclaringClass();
        List<HomeKitAccessoryTypeConfig> homeKitAccessoryTypeConfigs = Optional.ofNullable(homeKitAccessoryConfig.getAccessoryTypeMap().get(declaringClass)).orElseThrow(() -> new ClassNotFoundException(declaringClass.getName()));
        return Optional.ofNullable(homeKitAccessoryTypeConfigs.stream().collect(Collectors.toMap(HomeKitAccessoryTypeConfig::getMethod, v -> v)).get(method)).orElseThrow(() -> new NoSuchMethodException(declaringClass.getName().concat("#").concat(method.getName()).concat("()")));
    }

    public Object execute(Map<Method, HomekitCharacteristicChangeCallback> subscribeMap, Object[] args) {
        return this.method.invoke(subscribeMap, args);
    }
}

