/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryMethod;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeKitAccessoryProxy
implements InvocationHandler,
Serializable {
    private static final Logger log;
    private static final int ALLOWED_MODES = 15;
    private static final Method privateLookupInMethod;
    private static final Constructor<MethodHandles.Lookup> lookupConstructor;
    private final HomeKitAccessoryConfig homeKitAccessoryConfig;
    private final Map<Method, HomeKitAccessoryMethod> methodCacheMap;
    public static final String SUBSCRIBE_PREFIX = "subscribe";
    public static final String UNSUBSCRIBE_PREFIX = "unsubscribe";
    private final Map<Method, HomekitCharacteristicChangeCallback> subscribeMap = new ConcurrentHashMap<Method, HomekitCharacteristicChangeCallback>();

    public HomeKitAccessoryProxy(HomeKitAccessoryConfig homeKitAccessoryConfig, Map<Method, HomeKitAccessoryMethod> methodCacheMap) {
        this.homeKitAccessoryConfig = homeKitAccessoryConfig;
        this.methodCacheMap = methodCacheMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            if (method.isDefault()) {
                if (privateLookupInMethod == null) {
                    return this.invokeDefaultMethodJava8(proxy, method, args);
                }
                return this.invokeDefaultMethodJava9(proxy, method, args);
            }
        }
        catch (Throwable target) {
            log.error("homeKit accessory invoke method catch Error:{}", (Object)target.getMessage());
            throw target;
        }
        return this.handleSubscribeAndExecute(method, args);
    }

    private Object handleSubscribeAndExecute(Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.startsWith(SUBSCRIBE_PREFIX)) {
            if (this.subscribeMap.containsKey(method)) {
                log.warn("\u8ba2\u9605".concat(HomeKitAccessoryProxy.generateMethodKey(method)).concat("\u5df2\u5b58\u5728,\u8c03\u7528\u65b9\u6cd5:").concat(method.getDeclaringClass().getName()).concat("#").concat(methodName).concat("()"));
            } else {
                this.subscribeMap.put(method, (HomekitCharacteristicChangeCallback)args[0]);
                log.debug("\u8ba2\u9605\u6210\u529f:{},\u65b9\u6cd5:{}", (Object)HomeKitAccessoryProxy.generateMethodKey(method), (Object)method.getDeclaringClass().getName().concat("#").concat(methodName).concat("()"));
            }
            return null;
        }
        if (methodName.startsWith(UNSUBSCRIBE_PREFIX)) {
            if (this.subscribeMap.containsKey(method)) {
                this.subscribeMap.remove(method);
                log.debug("\u53d6\u6d88\u8ba2\u9605\u6210\u529f:{},\u8c03\u7528\u65b9\u6cd5:{}", (Object)HomeKitAccessoryProxy.generateMethodKey(method), (Object)method.getDeclaringClass().getName().concat("#").concat(methodName).concat("()"));
            } else {
                log.warn("\u8fd8\u6ca1\u6709\u8be5".concat(HomeKitAccessoryProxy.generateMethodKey(method)).concat("\u8ba2\u9605:").concat(method.getDeclaringClass().getName()).concat("#").concat(methodName).concat("()"));
            }
            return null;
        }
        HomeKitAccessoryMethod mapperMethod = this.cachedMapperMethod(method);
        return mapperMethod.execute(this.subscribeMap, args);
    }

    private HomeKitAccessoryMethod cachedMapperMethod(Method method) {
        return this.methodCacheMap.computeIfAbsent(method, k -> new HomeKitAccessoryMethod(this.homeKitAccessoryConfig, method));
    }

    private Object invokeDefaultMethodJava9(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        return ((MethodHandles.Lookup)privateLookupInMethod.invoke(null, declaringClass, MethodHandles.lookup())).findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    private Object invokeDefaultMethodJava8(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        return lookupConstructor.newInstance(declaringClass, 15).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    private static String generateMethodKey(Method targetMethod) {
        String methodName = targetMethod.getName();
        if (methodName.startsWith(SUBSCRIBE_PREFIX)) {
            return methodName.substring(9);
        }
        if (methodName.startsWith(UNSUBSCRIBE_PREFIX)) {
            return methodName.substring(11);
        }
        throw new IllegalArgumentException("\u65b9\u6cd5\u540d\u4e0d\u6b63\u786e:".concat(methodName));
    }

    public String toString() {
        return "HomeKitAccessoryProxy{homeKitAccessory=" + this.homeKitAccessoryConfig + ", methodCacheMap=" + this.methodCacheMap + '}';
    }

    static {
        Method privateLookupIn;
        log = LoggerFactory.getLogger(HomeKitAccessoryProxy.class);
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            privateLookupIn = null;
        }
        privateLookupInMethod = privateLookupIn;
        Constructor lookup = null;
        if (privateLookupInMethod == null) {
            try {
                lookup = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookup.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("There is neither 'privateLookupIn(Class, Lookup)' nor 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
            }
            catch (Throwable t) {
                lookup = null;
            }
        }
        lookupConstructor = lookup;
    }
}

