package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryType;
import io.github.hapjava.accessories.HomekitAccessory;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * HomeKitProxyFactory
 *
 * @author W9004844
 * @since 2020/01/19 14:26
 */
public class HomeKitAccessoryProxyFactory {

    /**
     * HomeKitAccessory数据库对象
     */
    private final HomeKitAccessoryConfig homeKitAccessoryConfig;

    /**
     * 不止有一个接口
     */
    private final Class<?>[] homeKitAccessoryInterfaces;

    /**
     * 方法缓存Map
     */
    private final Map<Method, HomeKitAccessoryMethod> methodCacheMap = new ConcurrentHashMap<>();

    public HomeKitAccessoryProxyFactory(HomeKitAccessoryConfig homeKitAccessoryConfig) {
        this.homeKitAccessoryInterfaces = homeKitAccessoryConfig.getHomeKitAccessoryTypes().stream()
                .map(HomeKitAccessoryType::getTypeClass)
                .peek(HomeKitAccessoryProxyFactory::checkClass)
                .toArray(Class[]::new);
        this.homeKitAccessoryConfig = homeKitAccessoryConfig;
    }

    private static void checkClass(Class<?> clazz) {
        String className = clazz.getName();
        if (!className.startsWith("io.github.hapjava.accessories")) {
            throw new IllegalArgumentException("this class ".concat(className).concat("is not supported"));
        }
    }

    public Class<?>[] getHomeKitAccessoryInterfaces() {
        return homeKitAccessoryInterfaces;
    }

    public Map<Method, HomeKitAccessoryMethod> getMethodCacheMap() {
        return methodCacheMap;
    }

    protected HomekitAccessory newInstance(HomeKitAccessoryProxy homeKitAccessoryProxy) {
        return (HomekitAccessory) Proxy.newProxyInstance(HomekitAccessory.class.getClassLoader(), homeKitAccessoryInterfaces, homeKitAccessoryProxy);
    }

    public HomekitAccessory newInstance() {
        return newInstance(new HomeKitAccessoryProxy(homeKitAccessoryConfig, methodCacheMap));
    }

}
