package cn.ximcloud.homekit.core.model;

import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * HomeKitAccessoryConfig
 *
 * @author W9004844
 * @since 2020/01/15 11:21
 */
@Data
public class HomeKitAccessoryConfig {

    /**
     * 主键ID
     */
    private int id;

    /**
     * Returns a name to display in iOS.
     *
     * @return the label.
     */
    private CompletableFuture<String> name;

    /**
     * Returns a serial number to display in iOS.
     *
     * @return the serial number, or null.
     */
    private CompletableFuture<String> serialNumber;

    /**
     * Returns a model name to display in iOS.
     *
     * @return the model name, or null.
     */
    private CompletableFuture<String> model;

    /**
     * Returns a manufacturer to display in iOS.
     *
     * @return the manufacturer, or null.
     */
    private CompletableFuture<String> manufacturer;

    /**
     * Returns a firmware revision to display in iOS.
     *
     * @return the firmware revision, or null.
     */
    private CompletableFuture<String> firmwareRevision;

    /**
     * 配件类型(包含配件和特征)
     */
    private List<HomeKitAccessoryType> homeKitAccessoryTypes;

}