/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryMethod;
import cn.ximcloud.homekit.core.utils.CommonUtil;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeKitAccessoryProxy
implements InvocationHandler,
Serializable {
    private static final Logger log;
    private static final int ALLOWED_MODES = 15;
    private static final Method privateLookupInMethod;
    private static final Constructor<MethodHandles.Lookup> lookupConstructor;
    private final HomeKitAccessoryConfig homeKitAccessoryConfig;
    private final Map<Method, HomeKitAccessoryMethod> methodCacheMap;
    public static final String SUBSCRIBE_PREFIX = "subscribe";
    public static final String UNSUBSCRIBE_PREFIX = "unsubscribe";
    private final Map<Method, HomekitCharacteristicChangeCallback> subscribeMap = new ConcurrentHashMap<Method, HomekitCharacteristicChangeCallback>();

    public HomeKitAccessoryProxy(HomeKitAccessoryConfig homeKitAccessoryConfig, Map<Method, HomeKitAccessoryMethod> methodCacheMap) {
        this.homeKitAccessoryConfig = homeKitAccessoryConfig;
        this.methodCacheMap = methodCacheMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            if (method.isDefault()) {
                if (privateLookupInMethod == null) {
                    return this.invokeDefaultMethodJava8(proxy, method, args);
                }
                return this.invokeDefaultMethodJava9(proxy, method, args);
            }
        }
        catch (Throwable target) {
            log.error("homeKit accessory invoke method catch Error:{}", (Object)target.getMessage());
            throw target;
        }
        return this.handleSubscribeAndExecute(method, args);
    }

    private Object handleSubscribeAndExecute(Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.startsWith(SUBSCRIBE_PREFIX)) {
            if (this.subscribeMap.containsKey(method)) {
                log.warn("subscription [{}] is existed,invoke method:{}", (Object)HomeKitAccessoryProxy.generateMethodKey(method), (Object)CommonUtil.generateMethodString(method));
            } else {
                log.debug("Successfully subscribed:{},method:{}", (Object)HomeKitAccessoryProxy.generateMethodKey(method), (Object)CommonUtil.generateMethodString(method));
            }
            this.subscribeMap.put(method, (HomekitCharacteristicChangeCallback)args[0]);
            return null;
        }
        if (methodName.startsWith(UNSUBSCRIBE_PREFIX)) {
            if (this.subscribeMap.containsKey(method)) {
                this.subscribeMap.remove(method);
                log.debug("Unsubscribe successfully:{},invoke method:{}", (Object)HomeKitAccessoryProxy.generateMethodKey(method), (Object)CommonUtil.generateMethodString(method));
            } else {
                log.warn("[{}] Not yet subscribed,method:{}", (Object)HomeKitAccessoryProxy.generateMethodKey(method), (Object)CommonUtil.generateMethodString(method));
            }
            return null;
        }
        HomeKitAccessoryMethod mapperMethod = this.cachedMapperMethod(method);
        return mapperMethod.execute(this.subscribeMap, args);
    }

    private HomeKitAccessoryMethod cachedMapperMethod(Method method) {
        return this.methodCacheMap.computeIfAbsent(method, k -> new HomeKitAccessoryMethod(this.homeKitAccessoryConfig, method));
    }

    private Object invokeDefaultMethodJava9(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        return ((MethodHandles.Lookup)privateLookupInMethod.invoke(null, declaringClass, MethodHandles.lookup())).findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    private Object invokeDefaultMethodJava8(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        return lookupConstructor.newInstance(declaringClass, 15).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    private static String generateMethodKey(Method targetMethod) {
        String methodName = targetMethod.getName();
        if (methodName.startsWith(SUBSCRIBE_PREFIX)) {
            return methodName.substring(9);
        }
        if (methodName.startsWith(UNSUBSCRIBE_PREFIX)) {
            return methodName.substring(11);
        }
        throw new IllegalArgumentException("Incorrect method name:".concat(methodName));
    }

    public String toString() {
        return "HomeKitAccessoryProxy{homeKitAccessory=" + this.homeKitAccessoryConfig + ", methodCacheMap=" + this.methodCacheMap + '}';
    }

    static {
        Method privateLookupIn;
        log = LoggerFactory.getLogger(HomeKitAccessoryProxy.class);
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            privateLookupIn = null;
        }
        privateLookupInMethod = privateLookupIn;
        Constructor lookup = null;
        if (privateLookupInMethod == null) {
            try {
                lookup = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookup.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("There is neither 'privateLookupIn(Class, Lookup)' nor 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
            }
            catch (Throwable t) {
                lookup = null;
            }
        }
        lookupConstructor = lookup;
    }
}

