/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryType;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryMethod;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryProxy;
import io.github.hapjava.accessories.HomekitAccessory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HomeKitAccessoryProxyFactory {
    private static final String ACCESS_PACKAGE_PREFIX = "io.github.hapjava.accessories";
    private final HomeKitAccessoryConfig homeKitAccessoryConfig;
    private final Class<?>[] homeKitAccessoryInterfaces;
    private final Map<Method, HomeKitAccessoryMethod> methodCacheMap = new ConcurrentHashMap<Method, HomeKitAccessoryMethod>();

    public HomeKitAccessoryProxyFactory(HomeKitAccessoryConfig homeKitAccessoryConfig) {
        this.homeKitAccessoryInterfaces = (Class[])homeKitAccessoryConfig.getHomeKitAccessoryTypes().stream().map(HomeKitAccessoryType::getTypeClass).peek(HomeKitAccessoryProxyFactory::checkClass).toArray(Class[]::new);
        this.homeKitAccessoryConfig = homeKitAccessoryConfig;
    }

    private static void checkClass(Class<?> clazz) {
        String className = clazz.getName();
        if (!className.startsWith(ACCESS_PACKAGE_PREFIX)) {
            throw new IllegalArgumentException("this class ".concat(className).concat("is not supported"));
        }
    }

    public Class<?>[] getHomeKitAccessoryInterfaces() {
        return this.homeKitAccessoryInterfaces;
    }

    public Map<Method, HomeKitAccessoryMethod> getMethodCacheMap() {
        return this.methodCacheMap;
    }

    protected HomekitAccessory newInstance(HomeKitAccessoryProxy homeKitAccessoryProxy) {
        return (HomekitAccessory)Proxy.newProxyInstance(HomekitAccessory.class.getClassLoader(), this.homeKitAccessoryInterfaces, (InvocationHandler)homeKitAccessoryProxy);
    }

    public HomekitAccessory newInstance() {
        return this.newInstance(new HomeKitAccessoryProxy(this.homeKitAccessoryConfig, this.methodCacheMap));
    }
}

