/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.proxy;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import cn.ximcloud.homekit.core.utils.CommonUtil;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodWrapper {
    private static final Logger log = LoggerFactory.getLogger(MethodWrapper.class);
    private final Method targetMethod;
    private final Object targetObject;
    private final HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig;
    private final String targetMethodKey;

    public MethodWrapper(Object targetObject, Method targetMethod) {
        this(targetObject, targetMethod, null);
    }

    public MethodWrapper(Object targetObject, Method targetMethod, HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig) {
        this.targetObject = targetObject;
        this.targetMethod = targetMethod;
        this.targetMethodKey = MethodWrapper.generateMethodKey(targetMethod);
        this.homeKitAccessoryTypeConfig = homeKitAccessoryTypeConfig;
    }

    public Object invoke(Map<Method, HomekitCharacteristicChangeCallback> subscribeMap, Object[] args) {
        Object targetReturnObject;
        if (this.homeKitAccessoryTypeConfig == null) {
            return this.targetMethod.invoke(this.targetObject, args);
        }
        switch (this.homeKitAccessoryTypeConfig.getInvokeType()) {
            case NOT_INVOKE: {
                targetReturnObject = null;
                break;
            }
            case VALUE: {
                targetReturnObject = this.generateValueReturnObject();
                break;
            }
            case INVOKE_METHOD: {
                targetReturnObject = this.targetMethod.invoke(this.targetObject, args);
                break;
            }
            case HTTP: {
                throw new IllegalArgumentException("Call type that does not exist");
            }
            default: {
                throw new IllegalArgumentException("Call type that does not exist");
            }
        }
        this.handleSubscription(subscribeMap);
        return targetReturnObject;
    }

    private void handleSubscription(Map<Method, HomekitCharacteristicChangeCallback> subscribeMap) {
        Map<String, HomekitCharacteristicChangeCallback> methodKeyMap = subscribeMap.entrySet().stream().collect(Collectors.toMap(k -> MethodWrapper.generateMethodKey((Method)k.getKey()), Map.Entry::getValue));
        String targetMethodName = this.targetMethod.getName();
        if (methodKeyMap.containsKey(this.targetMethodKey) && targetMethodName.startsWith("set")) {
            HomekitCharacteristicChangeCallback homekitCharacteristicChangeCallback = methodKeyMap.get(this.targetMethodKey);
            homekitCharacteristicChangeCallback.changed();
            log.debug("invoke method:[{}], subscription[{}] update", (Object)CommonUtil.generateMethodString(this.targetMethod), (Object)this.targetMethodKey);
        } else if (!targetMethodName.startsWith("get") && !targetMethodName.startsWith("is")) {
            log.debug("No such subscription:[{}],invoke method:{}", (Object)this.targetMethodKey, (Object)CommonUtil.generateMethodString(this.targetMethod));
            log.debug("Existing subscription:{}", methodKeyMap);
        }
    }

    private Object generateValueReturnObject() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> returnType = this.targetMethod.getReturnType();
        if (CompletableFuture.class.equals(returnType)) {
            Type[] actualTypeArguments;
            Type[] typeArray;
            int n;
            int n2;
            Type genericSuperclass = this.targetMethod.getGenericReturnType();
            if (genericSuperclass instanceof ParameterizedType && (n2 = 0) < (n = (typeArray = (actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments())).length)) {
                Object targetReturnObject;
                Type actualTypeArgument = typeArray[n2];
                Class targetReturnClass = (Class)actualTypeArgument;
                if (!Void.class.equals((Object)targetReturnClass)) {
                    String arg = Optional.ofNullable(this.homeKitAccessoryTypeConfig.getReturnArg()).orElseThrow(() -> new IllegalArgumentException("\u8fd4\u56de\u503c\u4e0d\u80fd\u4e3a\u7a7a")).getArg();
                    if (targetReturnClass.isEnum()) {
                        Method valueOf = targetReturnClass.getMethod("valueOf", String.class);
                        targetReturnObject = valueOf.invoke((Object)targetReturnClass, arg);
                    } else {
                        targetReturnObject = targetReturnClass.getConstructor(String.class).newInstance(arg);
                    }
                } else {
                    targetReturnObject = null;
                }
                return CompletableFuture.completedFuture(targetReturnObject);
            }
            throw new UnsupportedOperationException("This return type is not supported:".concat(returnType.getTypeName()).concat(genericSuperclass.getTypeName()));
        }
        if (Void.class.equals(returnType)) {
            return null;
        }
        throw new UnsupportedOperationException("This return type is not supported:".concat(returnType.getTypeName()));
    }

    private static String generateMethodKey(Method targetMethod) {
        String methodName = targetMethod.getName();
        if (methodName.startsWith("get")) {
            return methodName.substring(3);
        }
        if (methodName.startsWith("set")) {
            return methodName.substring(3);
        }
        if (methodName.startsWith("subscribe")) {
            return methodName.substring(9);
        }
        if (methodName.startsWith("unsubscribe")) {
            return methodName.substring(11);
        }
        return methodName;
    }
}

