package cn.ximcloud.homekit.core.execution;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import cn.ximcloud.homekit.core.exception.UnsupportedMethodException;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import cn.ximcloud.homekit.core.utils.CommonUtil;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * @author jecessewen
 */
public interface ExecutionScheduler {

    InvokeTypeEnum getExecutionType();

    Object execution(HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig, HomeKitAccessoryConfig targetObject, Method targetMethod, Object[] args);

    void preCheck(HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig, HomeKitAccessoryConfig targetObject, Method targetMethod, Object[] args);

    default void preCheck0(HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig, HomeKitAccessoryConfig targetObject, Method targetMethod, Object[] args) {
        if (Modifier.isAbstract(targetMethod.getModifiers()) && !targetMethod.equals(homeKitAccessoryTypeConfig.getMethod())) {
            throw new UnsupportedMethodException(String.format(
                    "homekitId:%s ,Cannot call abstract methods directly %s",
                    targetObject.getId(),
                    CommonUtil.generateMethodString(targetMethod)
            ));
        }
        preCheck(homeKitAccessoryTypeConfig, targetObject, targetMethod, args);
    }

    default Object execution0(HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig,
                              HomeKitAccessoryConfig targetObject,
                              Method targetMethod,
                              Object[] args) {
        preCheck0(homeKitAccessoryTypeConfig, targetObject, targetMethod, args);
        return execution(homeKitAccessoryTypeConfig, targetObject, targetMethod, args);
    }
}
