package cn.ximcloud.homekit.core.execution;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;

import java.util.Optional;

/**
 * @author jecessewen
 */
public class ExecutionSchedulerBuilder {

    private ExecutionSchedulerBuilder() {
    }


    public static ExecutionScheduler getExecutionSchedule(InvokeTypeEnum invokeType) {
        return Optional.ofNullable(ExecutionSchedulerRegistrar.getExecutionScheduler(invokeType))
                .orElseThrow(() -> new IllegalArgumentException("Call type ".concat(invokeType.toString()).concat(" does not match any exist execution scheduler !")));
    }
}
