package cn.ximcloud.homekit.core.execution;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import com.google.common.collect.Maps;
import org.reflections.Reflections;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExecutionSchedulerRegistrar {

    private static final String DEFAULT_EXECUTION_SCHEDULER = "cn.ximcloud.homekit.core.execution.impl";

    private static final Map<InvokeTypeEnum, ExecutionScheduler> EXECUTION_SCHEDULER_MAP = Maps.newHashMap();

    static {
        defaultRegister();
    }

    private ExecutionSchedulerRegistrar() {

    }

    private static void defaultRegister() {
        new Reflections(DEFAULT_EXECUTION_SCHEDULER).getSubTypesOf(ExecutionScheduler.class)
                .stream()
                .map(clazz -> {
                    try {
                        return clazz.getDeclaredConstructor().newInstance();
                    } catch (InstantiationException | IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
                        e.printStackTrace();
                        return null;
                    }
                })
                .filter(Objects::nonNull)
                .forEach(instance -> EXECUTION_SCHEDULER_MAP.put(instance.getExecutionType(), instance));
    }

    public static ExecutionScheduler getExecutionScheduler(InvokeTypeEnum invokeType) {
        return EXECUTION_SCHEDULER_MAP.get(invokeType);
    }

    public static ExecutionScheduler registrar(InvokeTypeEnum invokeType, ExecutionScheduler executionScheduler) {
        if (EXECUTION_SCHEDULER_MAP.containsKey(invokeType)) {
            throw new IllegalArgumentException();
        } else {
            return EXECUTION_SCHEDULER_MAP.put(invokeType, Optional.ofNullable(executionScheduler).orElseThrow(IllegalArgumentException::new));
        }
    }


}
