package cn.ximcloud.homekit.core.execution.impl;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import cn.ximcloud.homekit.core.execution.ExecutionScheduler;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import lombok.SneakyThrows;

import java.lang.reflect.Method;

/**
 * @author jecessewen
 */
public class DirectExecutionScheduler implements ExecutionScheduler {

    @Override
    public InvokeTypeEnum getExecutionType() {
        return InvokeTypeEnum.DIRECT_INVOKE_METHOD;
    }

    @SneakyThrows
    @Override
    public Object execution(HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig, HomeKitAccessoryConfig targetObject, Method targetMethod, Object[] args) {
        return targetMethod.invoke(targetObject, args);
    }

    @Override
    public void preCheck(HomeKitAccessoryTypeConfig homeKitAccessoryTypeConfig, HomeKitAccessoryConfig targetObject, Method targetMethod, Object[] args) {

    }
}
