package cn.ximcloud.homekit.core.model;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * HomeKitAccessoryConfig
 *
 * @author W9004844
 * @since 2020/01/15 11:21
 */
@Data
@Slf4j
public class HomeKitAccessoryConfig {

    /**
     * 主键ID
     */
    private int id;

    /**
     * Returns a name to display in iOS.
     */
    private CompletableFuture<String> name;

    /**
     * Returns a serial number to display in iOS.
     */
    private CompletableFuture<String> serialNumber;

    /**
     * Returns a model name to display in iOS.
     */
    private CompletableFuture<String> model;

    /**
     * Returns a manufacturer to display in iOS.
     */
    private CompletableFuture<String> manufacturer;

    /**
     * Returns a firmware revision to display in iOS.
     */
    private CompletableFuture<String> firmwareRevision;

    /**
     * 配件类型(包含配件和特征)
     */
    private List<HomeKitAccessoryType> homeKitAccessoryTypes;

    /**
     * Performs an operation that can be used to identify the accessory. This action can be performed
     * without pairing.
     */
    public void identify() {
        log.info("identify {}", this);
    }

    @Override
    public String toString() {
        return "HomeKitAccessoryConfig{" +
                "id=" + id +
                ", name=" + name.join() +
                ", serialNumber=" + serialNumber.join() +
                ", model=" + model.join() +
                ", manufacturer=" + manufacturer.join() +
                ", firmwareRevision=" + firmwareRevision.join() +
                ", homeKitAccessoryTypes=" + homeKitAccessoryTypes +
                '}';
    }
}