package cn.ximcloud.homekit.core.model;


import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import lombok.Data;

import java.lang.reflect.Method;

/**
 * AccessoryTypeConfig
 *
 * @author W9004844
 * @since 2020/01/20 16:16
 */

@Data
public class HomeKitAccessoryTypeConfig {

    /**
     * 方法名
     */
    private Method method;

    /**
     * 执行方式类型
     */
    private InvokeTypeEnum invokeType;

    /**
     * 返回参数
     */
    private ReturnArg returnArg;

    /**
     * 执行主体
     */
    private String invokeBody;

    @Override
    public String toString() {
        return "HomeKitAccessoryTypeConfig{" +
                "method=" + method.getName() +
                ", invokeType=" + invokeType +
                ", returnArg=" + returnArg +
                ", invokeBody='" + invokeBody + '\'' +
                '}';
    }
}
