package cn.ximcloud.homekit.core.starter.controller;

import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryVo;
import cn.ximcloud.homekit.core.starter.core.service.WebHomeKitService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("homekit")
public class HomeKitController {

    private final WebHomeKitService webHomeKitService;

    public HomeKitController(WebHomeKitService webHomeKitService) {
        this.webHomeKitService = webHomeKitService;
    }

    @GetMapping("getHomeKitList")
    public List<HomeKitAccessoryVo> getHomeKitList() {
        return webHomeKitService.getHomeKitList();
    }

    @GetMapping("getHomeKit/{id}")
    public HomeKitAccessoryVo getHomeKit(@PathVariable("id") Integer id) {
        return webHomeKitService.getHomeKit(id);
    }
}
