package cn.ximcloud.homekit.core.starter.core.accessories;

import io.github.hapjava.accessories.LightbulbAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithColorTemperature;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithHardwareRevision;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import lombok.extern.slf4j.Slf4j;

import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

/**
 * 一个灯光配件的demo 并且包含色温控制
 */
@Slf4j
public class DemoLightAccessory implements LightbulbAccessory, AccessoryWithHardwareRevision, AccessoryWithColorTemperature {

    private boolean powerState = false;

    private int colorTemperature;

    private HomekitCharacteristicChangeCallback subscribeCallback = null;

    private HomekitCharacteristicChangeCallback colorTemperatureCallback = null;

    @Override
    public int getId() {
        return Integer.MAX_VALUE - 1;
    }

    @Override
    public CompletableFuture<String> getName() {
        return CompletableFuture.completedFuture("Test Switch Name");
    }

    @Override
    public void identify() {
        log.info("Identifying light");
    }

    @Override
    public CompletableFuture<String> getSerialNumber() {
        return CompletableFuture.completedFuture("Test SwitchSN");
    }

    @Override
    public CompletableFuture<String> getModel() {
        return CompletableFuture.completedFuture("TestSwitch Model");
    }

    @Override
    public CompletableFuture<String> getManufacturer() {
        return CompletableFuture.completedFuture("Test SwitchManufacturer");
    }

    @Override
    public CompletableFuture<String> getFirmwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Firmware");
    }

    @Override
    public CompletableFuture<Boolean> getLightbulbPowerState() {
        return CompletableFuture.completedFuture(powerState);
    }

    {
        new Thread(() -> {
            while (true) {
                setLightbulbPowerState(new Random().nextInt(2) == 1);
                setColorTemperature(new Random().nextInt(100));
                try {
                    TimeUnit.SECONDS.sleep(5);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    public CompletableFuture<Void> setLightbulbPowerState(boolean powerState) {
        this.powerState = powerState;
        if (subscribeCallback != null) {
            subscribeCallback.changed();
        }
        log.info("The lightbulb is now " + (powerState ? "on" : "off"));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void subscribeLightbulbPowerState(HomekitCharacteristicChangeCallback callback) {
        this.subscribeCallback = callback;
    }

    @Override
    public void unsubscribeLightbulbPowerState() {
        this.subscribeCallback = null;
    }

    @Override
    public CompletableFuture<String> getHardwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Hardware");
    }

    /**
     * Retrieves the color temperature
     *
     * @return a future that will contain the brightness, expressed as an integer between 0 and 100.
     */
    @Override
    public CompletableFuture<Integer> getColorTemperature() {
        return CompletableFuture.completedFuture(this.colorTemperature);
    }

    /**
     * Sets the color temperature
     *
     * @param value the brightness, on a scale of 0 to 100, to set
     * @return a future that completes when the brightness is changed
     */
    @Override
    public CompletableFuture<Void> setColorTemperature(Integer value) {
        this.colorTemperature = value;
        if (colorTemperatureCallback != null) {
            colorTemperatureCallback.changed();
        }
        return CompletableFuture.completedFuture(null);
    }

    /**
     * Subscribes to changes in color temperature.
     *
     * @param callback the function to call when the color temperature changes.
     */
    @Override
    public void subscribeColorTemperature(HomekitCharacteristicChangeCallback callback) {
        this.colorTemperatureCallback = callback;
    }

    /**
     * Unsubscribes from changes in the color temperature.
     */
    @Override
    public void unsubscribeColorTemperature() {
        this.colorTemperatureCallback = null;
    }
}
