package cn.ximcloud.homekit.core.starter.core.adapter;

import cn.ximcloud.homekit.core.starter.config.HomeKitConfig;
import cn.ximcloud.homekit.core.starter.config.HomeKitDataSourceConfig;
import cn.ximcloud.homekit.core.starter.core.condition.BaseOnDatabaseHomeKitCondition;
import cn.ximcloud.homekit.core.starter.core.condition.EmbeddedDataBaseCondition;
import cn.ximcloud.homekit.core.starter.core.condition.SimpleDemoHomeKitCondition;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.impl.BaseOnDataBaseHomeKitService;
import cn.ximcloud.homekit.core.starter.core.service.impl.SimpleDemoHomeKitService;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryConfigRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAuthInfoRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitUserRepository;
import cn.ximcloud.homekit.core.starter.utils.HomekitAccessoryBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@Slf4j
@Component
@Configuration
@AutoConfigureBefore(DataSource.class)
public class HomeKitServiceAdapter {

    static {
        log.info("init homekit service adapter");
    }

    private final HomeKitAuthInfoRepository homeKitAuthInfoRepository;

    private final HomeKitUserRepository homeKitUserRepository;

    private final HomeKitConfig homeKitConfig;

    private final HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository;

    private final HomeKitDataSourceConfig homeKitDataSourceConfig;

    private final HomeKitAccessoryRepository homeKitAccessoryRepository;

    private final HomekitAccessoryBuilder homekitAccessoryBuilder;

    public HomeKitServiceAdapter(HomeKitAuthInfoRepository homeKitAuthInfoRepository,
                                 HomeKitUserRepository homeKitUserRepository,
                                 HomeKitConfig homeKitConfig,
                                 HomeKitAccessoryConfigRepository homeKitAccessoryConfigRepository,
                                 HomeKitDataSourceConfig homeKitDataSourceConfig,
                                 HomeKitAccessoryRepository homeKitAccessoryRepository,
                                 HomekitAccessoryBuilder homekitAccessoryBuilder) {
        this.homeKitAuthInfoRepository = homeKitAuthInfoRepository;
        this.homeKitUserRepository = homeKitUserRepository;
        this.homeKitConfig = homeKitConfig;
        this.homeKitAccessoryConfigRepository = homeKitAccessoryConfigRepository;
        this.homeKitDataSourceConfig = homeKitDataSourceConfig;
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
        this.homekitAccessoryBuilder = homekitAccessoryBuilder;
    }

    @Bean
    @Conditional(SimpleDemoHomeKitCondition.class)
    public HomeKitService generateSimpleDemoHomeKitServiceWithCondition() {
        log.info("using simple demo homekit service");
        return new SimpleDemoHomeKitService(homeKitConfig);
    }

    @Bean
    @Conditional(EmbeddedDataBaseCondition.class)
    public HomeKitService generateEmbeddedDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitService(
                homeKitAuthInfoRepository,
                homeKitUserRepository,
                homeKitConfig,
                homeKitAccessoryConfigRepository,
                homeKitDataSourceConfig,
                homeKitAccessoryRepository,
                homekitAccessoryBuilder
        );
    }

    @Bean
    @Conditional(BaseOnDatabaseHomeKitCondition.class)
    public HomeKitService generateDataBaseHomeKitServiceWithCondition() {
        log.info("using base on database homekit service");
        return new BaseOnDataBaseHomeKitService(
                homeKitAuthInfoRepository,
                homeKitUserRepository,
                homeKitConfig,
                homeKitAccessoryConfigRepository,
                homeKitDataSourceConfig,
                homeKitAccessoryRepository,
                homekitAccessoryBuilder
        );
    }
}
