package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.auth.SimpleDemoHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.config.HomeKitConfig;
import cn.ximcloud.homekit.core.starter.core.accessories.DemoLightAccessory;
import cn.ximcloud.homekit.core.starter.core.accessories.DemoSwitchAccessory;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;


@Slf4j
public class SimpleDemoHomeKitService implements HomeKitService {

    private final HomeKitConfig homeKitConfig;

    private final HomekitAuthInfo homeKitAuthInfo = new SimpleDemoHomeKitAuthInfo();

    public SimpleDemoHomeKitService(HomeKitConfig homeKitConfig) {
        this.homeKitConfig = homeKitConfig;
    }

    /**
     * 获取HomeKit 配置
     *
     * @return MockAuthInfo
     */
    @SneakyThrows
    @Override
    public HomekitAuthInfo getAuthInfo() {
        return homeKitAuthInfo;
    }

    /**
     * 设备列表
     *
     * @return List<HomeKitAccessory>
     */
    @Override
    public List<HomekitAccessory> getAccessories() {
        List<HomekitAccessory> accessories = new ArrayList<>();
        if (homeKitConfig.isAddDemo()) {
            accessories.add(DemoSwitchAccessory.generateSimpleDemoSwitchAccessory());
            accessories.add(new DemoLightAccessory());
        }
        return accessories;
    }

}
