package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.model.vo.HomeKitAccessoryVo;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import cn.ximcloud.homekit.core.starter.core.service.WebHomeKitService;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class WebHomeKitServiceImpl implements WebHomeKitService {

    private final HomeKitAccessoryRepository homeKitAccessoryRepository;

    public WebHomeKitServiceImpl(HomeKitAccessoryRepository homeKitAccessoryRepository) {
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
    }

    @Override
    public List<HomeKitAccessoryVo> getHomeKitList() {
        return Lists.newArrayList(homeKitAccessoryRepository.findAll()).stream().map(item -> {
            HomeKitAccessoryVo homeKitAccessoryVo = new HomeKitAccessoryVo();
            BeanUtils.copyProperties(item, homeKitAccessoryVo);
            return homeKitAccessoryVo;
        }).collect(Collectors.toList());
    }

    @Override
    public HomeKitAccessoryVo getHomeKit(Integer id) {
        HomeKitAccessoryVo homeKitAccessoryVo = new HomeKitAccessoryVo();
        HomeKitAccessoryEntity homeKitAccessoryEntity = homeKitAccessoryRepository.findById(id).orElse(null);
        if (homeKitAccessoryEntity == null) {
            homeKitAccessoryVo.setId(-1);
            return homeKitAccessoryVo;
        }

        BeanUtils.copyProperties(homeKitAccessoryEntity, homeKitAccessoryVo);
        return homeKitAccessoryVo;
    }
}
