package cn.ximcloud.homekit.core.starter.entity;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Data
@NoArgsConstructor
@Entity(name = "ximcloud_homekit_accessory_config")
public class HomeKitAccessoryConfigEntity implements Serializable {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;

    /**
     * Returns a name to display in iOS.
     */
    private String name;

    /**
     * Returns a serial number to display in iOS.
     */
    private String serialNumber;

    /**
     * Returns a model name to display in iOS.
     */
    private String model;

    /**
     * Returns a manufacturer to display in iOS.
     */
    private String manufacturer;

    /**
     * Returns a firmware revision to display in iOS.
     */
    private String firmwareRevision;

    /**
     * 配件类型
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "homeKitAccessoryConfigEntity", fetch = FetchType.EAGER)
    private List<HomeKitAccessoryTypeEntity> homeKitAccessoryTypes;

    /**
     * 描述
     */
    private String description;

}
