package cn.ximcloud.homekit.core.starter.entity;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.LocalDateTime;

@Data
@NoArgsConstructor
@Entity(name = "ximcloud_homekit_auth_info")
public class HomeKitAuthInfoEntity implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * pin
     */
    private String pin;

    /**
     * mac
     */
    private String mac;

    /**
     * salt
     */
    @Column(precision = 64)
    private BigInteger salt;

    /**
     * privateKey
     */
    private byte[] privateKey;

    /**
     * createTime
     */
    private LocalDateTime createTime;

    /**
     * updateTime
     */
    private LocalDateTime updateTime;

    public HomeKitAuthInfoEntity(String pin, String mac, BigInteger salt, byte[] privateKey) {
        this.pin = pin;
        this.mac = mac;
        this.salt = salt;
        this.privateKey = privateKey;
        this.createTime = LocalDateTime.now();
    }
}
