package cn.ximcloud.homekit.core.starter.entity.metadata;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;

@Data
@NoArgsConstructor
@Entity(name = "ximcloud_homekit_accessory_method")
public class HomeKitAccessoryMethodEntity implements Serializable {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;

    /**
     * 方法名
     */
    private String methodName;

    /**
     * 自定义的方法名
     */
    private String customizeMethodName;

    /**
     * 是否为默认方法
     */
    private boolean isDefault;

    /**
     * 多对一 配件entity
     */
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private HomeKitAccessoryEntity homeKitAccessory;

}
