package cn.ximcloud.homekit.core.starter.utils;

import io.github.hapjava.accessories.HomekitAccessory;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.TypeElementsScanner;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HomeKitAccessoryScanner {


    public static Set<Class<? extends HomekitAccessory>> scanHomeKitAccessory() {
        Reflections reflections = new Reflections("io.github.hapjava.accessories");
        return reflections.getSubTypesOf(HomekitAccessory.class);
    }

    public static List<Class<?>> scanHomeKitAccessoryOptionalCharacteristic() {
        Reflections reflections = new Reflections("io.github.hapjava.accessories.optionalcharacteristic", new TypeElementsScanner() {
            @Override
            public void scan(Object cls, Store store) {
                @SuppressWarnings("unchecked")
                Class<?> clazz = ReflectionUtils.forName(getMetadataAdapter().getClassName(cls));
                if (clazz.isInterface()) {
                    String className = clazz.getName();
                    store.put(className, className, className);
                }
            }

        });
        return reflections.getStore().keySet().stream().map(ReflectionUtils::forName).collect(Collectors.toList());
    }

}
