package cn.ximcloud.homekit.core.starter.utils;

import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryType;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryProxyFactory;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryConfigEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.utils.CommonUtil;
import io.github.hapjava.accessories.HomekitAccessory;
import org.apache.logging.log4j.util.Strings;
import org.reflections.ReflectionUtils;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class HomekitAccessoryCoverUtil {

    private HomekitAccessoryCoverUtil() {
    }

    public static final int ACCESSORY_OFFSET = 1000;

    public static HomekitAccessory coverToHomekitAccessory(HomeKitAccessoryConfigEntity homeKitAccessoryConfigEntity) {
        HomeKitAccessoryConfig homeKitAccessoryConfig = new HomeKitAccessoryConfig();
        homeKitAccessoryConfig.setId(ACCESSORY_OFFSET + homeKitAccessoryConfigEntity.getId());
        homeKitAccessoryConfig.setName(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getName()));
        homeKitAccessoryConfig.setSerialNumber(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getSerialNumber()));
        homeKitAccessoryConfig.setModel(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getModel()));
        homeKitAccessoryConfig.setManufacturer(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getManufacturer()));
        homeKitAccessoryConfig.setFirmwareRevision(CompletableFuture.completedFuture(homeKitAccessoryConfigEntity.getFirmwareRevision()));

        List<HomeKitAccessoryType> kitAccessoryTypes = homeKitAccessoryConfigEntity.getHomeKitAccessoryTypes().stream()
                .map(homeKitAccessoryTypeEntity -> {
                    HomeKitAccessoryType homeKitAccessoryType = new HomeKitAccessoryType();
                    HomeKitAccessoryEntity typeClass = homeKitAccessoryTypeEntity.getTypeClass();
                    homeKitAccessoryType.setTypeClass(typeClass.getClazz());

                    List<HomeKitAccessoryTypeConfig> homeKitAccessoryTypeConfigs = homeKitAccessoryTypeEntity.getAccessoryTypeConfig().stream()
                            .map(homeKitAccessoryTypeConfig -> {
                                HomeKitAccessoryTypeConfig accessoryTypeConfig = new HomeKitAccessoryTypeConfig();
//                              io.github.hapjava.accessories.FanAccessory#isActive[]!CompletableFuture<[java.lang.Boolean]>
                                HomeKitAccessoryMethodEntity homeKitAccessoryMethod = homeKitAccessoryTypeConfig.getMethod();
                                String customizeMethodName = homeKitAccessoryMethod.getCustomizeMethodName();
                                String[] split = customizeMethodName.split("#");
                                Class<?> clazz = ReflectionUtils.forName(split[0]);
                                String method = split[1].split("!")[0];
                                int start = method.indexOf("[");
                                int end = method.indexOf("]");
                                String methodName = method.substring(0, start);
                                String returnClass = method.substring(start + 1, end);
                                Method declaredMethod;
                                try {
                                    if (Strings.isBlank(returnClass)) {
                                        declaredMethod = clazz.getDeclaredMethod(methodName);
                                    } else if (!Strings.isBlank(returnClass) && returnClass.contains(",")) {
                                        declaredMethod = clazz.getDeclaredMethod(methodName, Arrays.stream(returnClass.split(",")).map(ReflectionUtils::forName).toArray(Class[]::new));
                                    } else {
                                        declaredMethod = clazz.getDeclaredMethod(methodName, ReflectionUtils.forName(returnClass));
                                    }
                                } catch (NoSuchMethodException e) {
                                    throw new IllegalArgumentException("method not found:".concat(methodName));
                                }

                                accessoryTypeConfig.setMethod(declaredMethod);
                                accessoryTypeConfig.setInvokeType(homeKitAccessoryTypeConfig.getInvokeType());
                                accessoryTypeConfig.setReturnArg(homeKitAccessoryTypeConfig.getReturnArg());
                                accessoryTypeConfig.setInvokeBody(homeKitAccessoryTypeConfig.getInvokeBody());
                                return accessoryTypeConfig;
                            }).collect(Collectors.toList());
                    homeKitAccessoryType.setAccessoryTypeConfig(homeKitAccessoryTypeConfigs);
                    return homeKitAccessoryType;
                }).collect(Collectors.toList());
        homeKitAccessoryConfig.setHomeKitAccessoryTypes(kitAccessoryTypes);
        return new HomeKitAccessoryProxyFactory(homeKitAccessoryConfig).newInstance();
    }


    public static HomeKitAccessoryMethodEntity coverToHomeKitAccessoryMethodEntity(Method method) {
        HomeKitAccessoryMethodEntity methodEntity = new HomeKitAccessoryMethodEntity();
        methodEntity.setMethodName(method.getName());
        methodEntity.setDefault(method.isDefault());
        methodEntity.setCustomizeMethodName(CommonUtil.generateMethodString(method));
        return methodEntity;
    }
}
