/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.auth;

import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDemoHomeKitAuthInfo
implements HomekitAuthInfo {
    private static final Logger log = LoggerFactory.getLogger(SimpleDemoHomeKitAuthInfo.class);
    private final String pin;
    private final String mac;
    private final BigInteger salt;
    private final byte[] privateKey;
    private Map<String, byte[]> userMap = new ConcurrentHashMap<String, byte[]>();
    private final transient File authFile = new File("auth-state.bin");

    public SimpleDemoHomeKitAuthInfo() {
        if (this.authFile.exists()) {
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.authFile));){
                System.out.println("Using persisted auth");
                SimpleDemoHomeKitAuthInfo simpleDemoHomeKitAuthInfo = (SimpleDemoHomeKitAuthInfo)objectInputStream.readObject();
                this.pin = simpleDemoHomeKitAuthInfo.pin;
                this.mac = simpleDemoHomeKitAuthInfo.mac;
                this.salt = simpleDemoHomeKitAuthInfo.salt;
                this.privateKey = simpleDemoHomeKitAuthInfo.privateKey;
                this.userMap = simpleDemoHomeKitAuthInfo.userMap;
            }
        } else {
            this.pin = HomekitServer.generatePin();
            this.mac = HomekitServer.generateMac();
            this.salt = HomekitServer.generateSalt();
            this.privateKey = HomekitServer.generateKey();
            this.notifyChanged();
        }
        log.info("The PIN for pairing is {}", (Object)this.pin);
    }

    private void notifyChanged() {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.authFile));){
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getPin() {
        return this.pin;
    }

    public String getMac() {
        return this.mac;
    }

    public BigInteger getSalt() {
        return this.salt;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public void createUser(String username, byte[] publicKey) {
        if (!this.userMap.containsKey(username)) {
            this.userMap.putIfAbsent(username, publicKey);
            log.info("Added user for {}", (Object)username);
        } else {
            log.warn("Already have this user for {}", (Object)username);
        }
        this.notifyChanged();
    }

    public void removeUser(String username) {
        if (this.userMap.containsKey(username)) {
            this.userMap.remove(username);
            log.info("Removed pairing for {}", (Object)username);
        } else {
            log.warn("the user {} not found", (Object)username);
        }
        this.notifyChanged();
    }

    public byte[] getUserPublicKey(String username) {
        if (this.userMap.containsKey(username)) {
            return this.userMap.get(username);
        }
        log.warn("the user {} not found", (Object)username);
        return null;
    }

    public boolean hasUser() {
        return !this.userMap.isEmpty();
    }
}

