/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.adapter;

import cn.ximcloud.homekit.core.starter.config.HomeKitDataSourceConfig;
import cn.ximcloud.homekit.core.starter.constants.DataSourceConstant;
import cn.ximcloud.homekit.core.starter.core.adapter.HomeKitServiceAdapter;
import cn.ximcloud.homekit.core.starter.core.condition.EmbeddedDataBaseCondition;
import cn.ximcloud.homekit.core.starter.core.condition.SimpleDemoHomeKitCondition;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ComponentScan(value={"cn.ximcloud.homekit.core.starter"})
@AutoConfigureAfter(value={HomeKitDataSourceConfig.class})
@EntityScan(value={"cn.ximcloud.homekit.core.starter.entity"})
@EnableJpaRepositories(value={"cn.ximcloud.homekit.core.starter.repository"})
@AutoConfigureBefore(value={DataSource.class, HomeKitServiceAdapter.class})
public class HomeKitDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(HomeKitDataSourceAdapter.class);
    private final HomeKitDataSourceConfig homeKitDataSourceConfig;

    public HomeKitDataSourceAdapter(HomeKitDataSourceConfig homeKitDataSourceConfig) {
        this.homeKitDataSourceConfig = homeKitDataSourceConfig;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSource.class})
    @Conditional(value={SimpleDemoHomeKitCondition.class})
    public DataSource generateUnUsedDataSource() {
        log.info("generate unused DataSource");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("org.h2.Driver");
        hikariConfig.setJdbcUrl("jdbc:h2:mem:unused");
        hikariConfig.setUsername("sa");
        hikariConfig.setPassword("sa");
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSource.class})
    @Conditional(value={EmbeddedDataBaseCondition.class})
    public DataSource generateEmbeddedDataSource() {
        log.info("generate Embedded DataSource");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("org.h2.Driver");
        String jdbcUrl = this.generateJdbcUrl();
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername("sa");
        hikariConfig.setPassword("sa");
        log.info("the jdbc url is:[{}] ,username:[{}],password:[{}]", new Object[]{jdbcUrl, hikariConfig.getUsername(), hikariConfig.getPassword()});
        return new HikariDataSource(hikariConfig);
    }

    private String generateJdbcUrl() {
        if (DataSourceConstant.EMBEDDED.equals((Object)this.homeKitDataSourceConfig.getType())) {
            return "jdbc:h2:mem:ximcloud_homekit";
        }
        return "jdbc:h2:file:".concat(Optional.ofNullable(this.homeKitDataSourceConfig.getFile()).orElse("./db/ximcloud_homekit"));
    }

    static {
        log.info("init datasource adapter");
    }
}

